#pragma config(Sensor, S4,     					lightSensor,   sensorEV3_Color)
#pragma config(Motor,  motorB,          leftMotor,     tmotorEV3_Large, PIDControl, driveLeft, encoder)
#pragma config(Motor,  motorC,          rightMotor,    tmotorEV3_Large, PIDControl, driveRight, encoder)
//*!!Code automatically generated by 'ROBOTC' configuration wizard               !!*//

task main()
{
	int speedTurn;
	int black, white, treshold;
  int error, errorOld, errorDelta;
  float integral, timeDelta;
  float P, I, D;

  // Nastavljanje konstant PID
  //	- zacetek: Kp = 3, Ti = 1000000, Td = 0 --> prevec niha --> zmanjsamo -->
  //	- kriticni Kp = Ku = 1.2 (nihanje se ne neha), Tu = 0.3 s -->
  //	- Zigler Nichols: Kp = 0.6, Ti = 0.15, Td = 0.075
  //	- popravki: Kp = 1, Ti = 0.15, Td = 0.0375
  float Kp = 0.5;
  float Ti = 5;
  float Td = 0;
	int speedTravel = 50;

	// umeritev
	black = SensorValue[S4];
	moveMotor(motorB, 90, degrees, 20);
	wait(1000, milliseconds);
	white = SensorValue[S4];
	moveMotor(motorB, -90, degrees, 20);
	treshold = (black + white) / 2;

  // glavna zanka
  integral = 0.0;
  errorOld = SensorValue[S4] - treshold;
  clearTimer(T1);
	repeat(forever)
  {
    // cas cikla
    timeDelta = time1[T1] / 1000.0;
	  clearTimer(T1);

    // napaka
		error = SensorValue[S4] - treshold;
    errorDelta = error - errorOld;
    errorOld = error;

    // proporcionalni clen
    P = Kp * error;

    // integralni clen
    integral = integral + error * timeDelta;
    I = Kp / Ti * integral;

    // diferencialni clen
    if (timeDelta > 0)
      D = Kp * Td * errorDelta / timeDelta;
    else
      D = 0.0;

    // izracun regulirne kolicine
    speedTurn = (int)(P + I + D);

    // sprememba hitrosti motorjev
		setMotor(motorB, speedTravel - speedTurn);
		setMotor(motorC, speedTravel + speedTurn);
  }
}
