from PyQt5 import uic, QtWidgets
import urllib.request

class Valute:
    def __init__(self):
        dlg = self.dlg = uic.loadUi("valute.ui")
        self.preberi_tecajno()
        dlg.cbValuta.addItems(list(self.tecaji))
        dlg.cbValuta.currentIndexChanged.connect(self.preracunaj)
        dlg.leZnesek.textChanged.connect(self.preracunaj)
        dlg.show()

    def preberi_tecajno(self):
        v = urllib.request.urlopen("https://www.nlb.si/services/tecajnica/?type=individuals&format=txt")
        s = v.read().decode("ascii").splitlines()[1:]
        self.tecaji = {}
        for vrstica in s:
            vrstica = vrstica.split()
            ime = vrstica[5]
            vrednost = float(vrstica[6].replace(",", "."))
            self.tecaji[ime] = vrednost

    def preracunaj(self):
        try:
            dlg = self.dlg
            v = float(dlg.leZnesek.text()) * self.tecaji[dlg.cbValuta.currentText()]
            dlg.lbVrednost.setText("{:.2f}".format(v))
        except:
            dlg.lbVrednost.setText("...")

app = QtWidgets.QApplication([])
val = Valute()
app.exec()
