from PyQt5 import uic, QtWidgets, QtMultimedia, QtCore

class Odstevalnik:
    def __init__(self):
        dlg = self.dlg = uic.loadUi("odstevalnik.ui")
        self.zvok = QtMultimedia.QSound("ringing.wav")
        self.zvok = QtMultimedia.QMediaPlayer()
        self.zvok.setMedia(QtMultimedia.QMediaContent(QtCore.QUrl.fromLocalFile("ringing.wav")))

        self.dlg.btIzberiZvok.clicked.connect(self.izberiZvok)

        self.dlg.btZacni.clicked.connect(self.zacni)

        self.timer = QtCore.QTimer()
        self.timer.setInterval(1000)
        self.timer.timeout.connect(self.odstej)
        dlg.show()

    def izberiZvok(self):
        n = QtWidgets.QFileDialog.getOpenFileName(
            None, "Izberi zvočno datoteko", ".",
            "Zvočne datoteke (*.mp3 *.wav *.m4a)"
        )
        if n:
            self.zvok.setMedia(QtMultimedia.QMediaContent(
                QtCore.QUrl.fromLocalFile(n[0])))

    def sprozi(self):
        self.zvok.setVolume(100)
        self.zvok.play()

    def zacni(self):
        self.timer.start()

    def odstej(self):
        dlg = self.dlg
        sek = dlg.sbSec.value()
        min = dlg.sbMin.value()
        if sek > 0:
            sek -= 1
        elif min > 0:
            min -= 1
            sek = 59
        dlg.sbSec.setValue(sek)
        dlg.sbMin.setValue(min)
        if sek == min == 0:
            self.zvok.play()
            self.timer.stop()


app = QtWidgets.QApplication([])
ods = Odstevalnik()
app.exec()
