import unittest

class Test06(unittest.TestCase):
    def test_read_file(self):
        bots, instructions = read_file("example.txt")
        self.assertEqual(bots[1], [3])
        self.assertEqual(set(bots[2]), {2, 5})
        self.assertEqual(instructions,
                         {2: (("bot", 1), ("bot", 0)),
                          1: (("output", 1), ("bot", 0)),
                          0: (("output", 2), ("output", 0))})

        bots, instructions = read_file("input.txt")
        self.assertEqual(bots[206], [43])
        self.assertEqual(instructions[106], (("bot", 83), ("bot", 82)))
        self.assertEqual(instructions[48], (("bot", 190), ("bot", 156)))
        self.assertEqual(instructions[53], (("output", 0), ("bot", 6)))

        bots, instructions = read_file("example2.txt")
        self.assertEqual(instructions,
                         {1: (('bot', 3), ('bot', 4)),
                          2: (('bot', 4), ('output', 0)),
                          3: (('output', 5), ('bot', 5)),
                          4: (('bot', 5), ('bot', 6)),
                          5: (('output', 1), ('bot', 7)),
                          6: (('bot', 7), ('output', 4)),
                          7: (('output', 2), ('output', 3))}
                         )
        bots = {k: sorted(v) for k, v in bots.items()}
        self.assertEqual(bots, {1: [1, 2], 2: [3, 4], 3: [5], 6: [6]})

    def test_highest_output(self):
        self.assertEqual(highest_output({2: (("bot", 1), ("bot", 0)),
                                         1: (("output", 1), ("bot", 0)),
                                         0: (("output", 2), ("output", 0))}), 2)
        self.assertEqual(highest_output({0: (("output", 1), ("output", 0))}), 1)
        self.assertEqual(highest_output({0: (("output", 4), ("output", 0))}), 4)
        self.assertEqual(highest_output({0: (("output", 0), ("output", 4))}), 4)
        self.assertEqual(highest_output({2: (("bot", 1), ("bot", 0)),
                                         1: (("output", 1), ("bot", 0)),
                                         0: (("output", 42), ("output", 0))}), 42)
        self.assertEqual(highest_output({2: (("bot", 1), ("bot", 0)),
                                         1: (("output", 1), ("bot", 0)),
                                         0: (("output", 0), ("output", 42))}), 42)


class Test07(unittest.TestCase):
    def test_execute(self):
        from copy import deepcopy
        from collections import defaultdict
        initial = defaultdict(list)
        initial.update({0: [42], 1: [13, 60], 2: [61, 15], 3: [], 4: [16, 62]})
        instructions = {0: (("output", 1), ("bot", 3)),
                        1: (("output", 2), ("bot", 0)),
                        2: (("bot", 3), ("bot", 0)),
                        3: (("output", 0), ("output", 3)),
                        4: (("bot", 6), ("bot", 5))}
        outputs = [None] * 4
        bots = deepcopy(initial)
        self.assertFalse(execute(bots, outputs, 0, instructions))
        self.assertEqual(bots, initial)
        self.assertEqual(outputs, [None] * 4)

        self.assertFalse(execute(bots, outputs, 3, instructions))
        self.assertEqual(bots, initial)
        self.assertEqual(outputs, [None] * 4)

        self.assertTrue(execute(bots, outputs, 1, instructions))
        bots = {k: sorted(v) for k, v in bots.items()}
        self.assertEqual(bots, {0: [42, 60], 1: [], 2: [15, 61], 3: [], 4: [16, 62]})
        self.assertEqual(outputs, [None, None, 13, None])

        bots = deepcopy(initial)
        outputs = [None] * 4
        self.assertTrue(execute(bots, outputs, 2, instructions))
        bots = {k: sorted(v) for k, v in bots.items()}
        self.assertEqual(bots, {0: [42, 61], 1: [13, 60], 2: [], 3: [15], 4: [16, 62]})
        self.assertEqual(outputs, [None] * 4)

        bots = deepcopy(initial)
        outputs = [None] * 4
        self.assertTrue(execute(bots, outputs, 4, instructions))
        bots = {k: sorted(v) for k, v in bots.items()}
        self.assertEqual(bots, {0: [42], 1: [13, 60], 2: [15, 61], 3: [], 4: [], 5: [62], 6: [16]})
        self.assertEqual(outputs, [None] * 4)


class Test08(unittest.TestCase):
    def test_run(self):
        bots, instructions = read_file("example.txt")
        self.assertEqual(run(bots, instructions), [5, 2, 3])

        bots, instructions = read_file("example2.txt")
        self.assertEqual(run(bots, instructions), [4, 2, 3, 5, 6, 1])

        bots, instructions = read_file("input.txt")
        self.assertEqual(run(bots, instructions), [7, 53, 37, 29, 13, 59, 3, 47, 23, 73, 41, 5, 61, 19, 43, 17, 2, 67, 11, 31, 71])


class Test09(unittest.TestCase):
    def test_count_paths(self):
        bots, instructions = read_file("example.txt")
        self.assertEqual(count_paths(0, instructions), 2)
        self.assertEqual(count_paths(1, instructions), 3)
        self.assertEqual(count_paths(2, instructions), 5)

        bots, instructions = read_file("example2.txt")
        self.assertEqual(count_paths(7, instructions), 2)
        self.assertEqual(count_paths(6, instructions), 3)
        self.assertEqual(count_paths(5, instructions), 3)
        self.assertEqual(count_paths(4, instructions), 6)
        self.assertEqual(count_paths(3, instructions), 4)
        self.assertEqual(count_paths(2, instructions), 7)
        self.assertEqual(count_paths(1, instructions), 10)


class Test10(unittest.TestCase):
    def test_bots_on_path(self):
        bots, instructions = read_file("example2.txt")
        self.assertEqual(bots_on_path(4, instructions), {1, 2, 4, 6})

        bots, instructions = read_file("input.txt")
        self.assertEqual(bots_on_path(0, instructions),
                         {0, 129, 2, 3, 132, 136, 11, 140, 12, 141, 16, 17, 148,
                          21, 150, 151, 22, 153, 25, 27, 154, 29, 158, 152, 32,
                          161, 155, 36, 165, 37, 39, 40, 168, 43, 172, 45, 46,
                          176, 49, 50, 52, 53, 182, 57, 187, 188, 189, 191, 64,
                          65, 197, 201, 73, 205, 206, 207, 77, 209, 84, 85, 86,
                          87, 89, 91, 93, 97, 101, 103, 105, 114, 117, 119, 121,
                          123}
                         )


class TestZaZdolgocasene(unittest.TestCase):
    def test_count_paths(self):
        bots, instructions = read_file("input.txt")
        self.assertEqual(count_paths(2, instructions), 1771605360)
        self.assertEqual(count_paths(97, instructions), 24466267020)


if __name__ == "__main__":
    unittest.main()
