import unittest
class TestTrgovina(unittest.TestCase):
    def setUp(self):
        import warnings
        warnings.filterwarnings("ignore", category=ResourceWarning)

    def test_preberi_inventar(self):
        self.assertDictEqual(
            preberi_inventar("inventar.txt"),
            {'sir': 8, 'kruh': 15, 'makovka': 10, 'pasja radost': 2,
             'salama': 10, 'mortadela': 4, 'klobasa': 7})
        self.assertDictEqual(
            preberi_inventar("narocilo-1.txt"),
            {"makovka": 5})
        self.assertDictEqual(
            preberi_inventar("narocilo-2.txt"),
            {"makovka": 5, "kruh": 3, "pivo": 4, "maslo": 2})

    def test_zaloga(self):
        inv = {"kruh": 5, "kajzerica": 4, "makovka": 3}
        self.assertEqual(zaloga(inv, "kruh"), 5)
        self.assertEqual(zaloga(inv, "kajzerica"), 4)
        self.assertEqual(zaloga(inv, "makovka"), 3)

    def test_prodaj(self):
        inv = {"kruh": 5, "kajzerica": 4, "makovka": 3}
        prodaj(inv, "kajzerica", 2)
        self.assertEqual(zaloga(inv, "kruh"), 5)
        self.assertEqual(zaloga(inv, "kajzerica"), 2)
        self.assertEqual(zaloga(inv, "makovka"), 3)

        prodaj(inv, "kruh", 5)
        self.assertTrue("kruh" not in inv or (zaloga(inv, "kruh"), 0))
        self.assertEqual(zaloga(inv, "kajzerica"), 2)
        self.assertEqual(zaloga(inv, "makovka"), 3)

    def test_preberi_narocilo(self):
        self.assertDictEqual(
            preberi_narocilo("inventar.txt"),
            {'sir': 8, 'kruh': 15, 'makovka': 10, 'pasja radost': 2,
             'salama': 10, 'mortadela': 4, 'klobasa': 7})
        self.assertDictEqual(
            preberi_narocilo("narocilo-1.txt"), {"makovka": 5})
        self.assertDictEqual(
            preberi_narocilo("narocilo-2.txt"),
            {"makovka": 5, "kruh": 3, "pivo": 4, "maslo": 2})

    def test_primanjkljaj(self):
        inventar = preberi_inventar("inventar.txt")
        self.assertDictEqual(
            primanjkljaj(inventar, {"kruh": 2, "makovka": 10}),
            {})
        self.assertDictEqual(
            primanjkljaj(inventar, {"kruh": 2, "makovka": 12}),
            {"makovka": 2})
        self.assertDictEqual(
            primanjkljaj(inventar, {"kruh": 2, "makovka": 12, "pivo": 3}),
            {"makovka": 2, "pivo": 3})
        self.assertDictEqual(primanjkljaj(inventar, {}), {})
        self.assertDictEqual(primanjkljaj(inventar, inventar), {})

    def test_zberi_narocila(self):
        self.assertDictEqual(zberi_narocila([]), {})
        self.assertDictEqual(zberi_narocila(["narocilo-1.txt"]), {"makovka": 5})
        self.assertDictEqual(
            zberi_narocila(["narocilo-1.txt", "narocilo-2.txt"]),
            {'kruh': 3, 'makovka': 10, 'maslo': 2, 'pivo': 4})
        self.assertDictEqual(
            zberi_narocila(["narocilo-1.txt", "narocilo-3.txt"]),
            {'makovka': 5, 'pivo': 2})
        self.assertDictEqual(
            zberi_narocila(["narocilo-1.txt", "narocilo-2.txt",
                            "narocilo-3.txt"]),
            {'kruh': 3, 'makovka': 10, 'pivo': 6, 'maslo': 2})

    def test_izracunaj_dobavo(self):
        inventar = preberi_inventar("inventar.txt")
        self.assertDictEqual(
            izracunaj_dobavo(inventar, {"kruh": 2, "makovka": 10}),
            {})
        self.assertDictEqual(
            izracunaj_dobavo(inventar, {"kruh": 2, "makovka": 12}),
            {"makovka": 2})
        self.assertDictEqual(
            izracunaj_dobavo(inventar, {"kruh": 2, "makovka": 12, "pivo": 3}),
            {"makovka": 2, "pivo": 3})
        self.assertDictEqual(izracunaj_dobavo(inventar, {}), {})
        self.assertDictEqual(izracunaj_dobavo(inventar, inventar), {})


if __name__ == "__main__":
    unittest.main()
