

import unittest
import warnings
import time

class NoWarningTest(unittest.TestCase):
    def setUp(self) -> None:
        super().setUp()
        warnings.simplefilter("ignore", ResourceWarning)

class Test06(NoWarningTest):
    def test_01_preberi_zemljevid(self):
        self.assertIsNotNone(preberi_zemljevid("dravlje.txt"))
        self.assertIsNotNone(preberi_zemljevid("bezigrad.txt"))

    def test_02_najblizji(self):
        args = (set(), ) if najblizji.__code__.co_argcount == 5 else ()

        zemljevid = preberi_zemljevid("dravlje.txt")
        self.assertEqual((1, 5), najblizji(0, 1, "a", zemljevid, *args))
        self.assertEqual((0, 1), najblizji(1, 1, "r", zemljevid, *args))
        self.assertEqual((0, 1), najblizji(0, 0, "r", zemljevid, *args))
        self.assertEqual((0, 1), najblizji(0, 0, "r", zemljevid, *args))
        self.assertEqual((0, 1), najblizji(2, 1, "r", zemljevid, *args))
        self.assertEqual((1, 0), najblizji(2, 0, "r", zemljevid, *args))
        self.assertEqual((1, 0), najblizji(0, 1, "r", zemljevid, *args))
        self.assertEqual((7, 4), najblizji(4, 2, "l", zemljevid, *args))

        self.assertEqual((5, 2), najblizji(7, 2, "", zemljevid, *args))
        self.assertEqual((1, 2), najblizji(5, 2, "", zemljevid, *args))

        zemljevid = preberi_zemljevid("bezigrad.txt")
        self.assertEqual((38, 83), najblizji(40, 80, "l", zemljevid, *args))

    def test_03_najpogostejsi(self):
        zemljevid = preberi_zemljevid("dravlje.txt")

        self.assertEqual("r", najpogostejsi(2, 2, 3, zemljevid))
        self.assertEqual("r", najpogostejsi(2, 2, 6, zemljevid))
        self.assertEqual("b", najpogostejsi(2, 2, 1, zemljevid))
        self.assertEqual("c", najpogostejsi(9, 2, 4, zemljevid))
        self.assertEqual("a", najpogostejsi(9, 2, 3, zemljevid))
        self.assertIsNone(najpogostejsi(9, 2, 2, zemljevid))

    def test_04_vsi_najpogostejsi(self):
        zemljevid = preberi_zemljevid("dravlje.txt")
        self.assertEqual({"p", "b"}, vsi_najpogostejsi(2, 2, 2, zemljevid))
        self.assertEqual(set(), vsi_najpogostejsi(5, 5, 2, zemljevid))
        self.assertEqual({"a", "g", "l"}, vsi_najpogostejsi(6, 6, 6, zemljevid))
        self.assertEqual({"r", "c"}, vsi_najpogostejsi(6, 0, 5, zemljevid))


class Test07(NoWarningTest):
    def test_01_najblizji(self):
        zemljevid = preberi_zemljevid("dravlje.txt")
        self.assertEqual((1, 5), najblizji(0, 1, "a", zemljevid, set()))
        self.assertEqual((9, 5), najblizji(0, 1, "a", zemljevid, {(1, 5)}))
        self.assertEqual((1, 5), najblizji(0, 1, "a", zemljevid, {(9, 5)}))
        self.assertIsNone(najblizji(0, 1, "a", zemljevid, {(1, 5), (9, 5)}))

        self.assertEqual((0, 1), najblizji(1, 1, "r", zemljevid, set()))
        self.assertEqual((0, 1), najblizji(1, 1, "r", zemljevid, {(1, 0)}))
        self.assertEqual((1, 0), najblizji(1, 1, "r", zemljevid, {(0, 1)}))
        self.assertEqual((5, 2), najblizji(1, 1, "r", zemljevid, {(0, 1), (1, 0)}))
        self.assertIsNone(najblizji(1, 1, "r", zemljevid, {(0, 1), (1, 0), (5, 2)}))

        self.assertEqual((5, 2), najblizji(7, 2, "", zemljevid, set()))
        self.assertEqual((1, 2), najblizji(5, 2, "", zemljevid, {(5, 2)}))
        self.assertEqual((7, 4), najblizji(5, 2, "", zemljevid, {(5, 2), (1, 2), (2, 1)}))
        self.assertEqual((8, 0), najblizji(5, 2, "", zemljevid, {(5, 2), (1, 2), (2, 1), (7, 4)}))

        self.assertIsNone(
            najblizji(5, 2, "", zemljevid,
                      {(0, 1), (7, 4), (1, 2), (2, 1), (2, 7), (11, 0), (1, 5), (3, 7), (10, 7), (1, 4), (8, 0),
                       (9, 5), (1, 0), (2, 5), (5, 2)}))

        zemljevid = preberi_zemljevid("bezigrad.txt")
        self.assertIsNone(
            najblizji(40, 80, "l", zemljevid,
                      {(110, 2), (1, 95), (98, 46), (26, 39), (90, 42), (19, 0), (82, 38), (55, 84), (90, 60), (19, 18),
                       (58, 95), (104, 62), (106, 4), (29, 68), (75, 35), (115, 71), (21, 64), (72, 11), (41, 42),
                       (87, 9), (64, 7), (106, 22), (53, 16), (2, 32), (116, 54), (72, 29), (20, 86), (93, 70),
                       (51, 73), (98, 5), (117, 55), (67, 36), (85, 84), (93, 88), (35, 65), (89, 36), (78, 45),
                       (55, 43), (24, 74), (43, 87), (89, 54), (113, 21), (35, 83), (32, 96), (55, 61), (90, 37),
                       (91, 2), (71, 42), (0, 0), (9, 67), (83, 16), (100, 87), (29, 45), (6, 43), (21, 41), (40, 54),
                       (9, 85), (5, 96), (29, 63), (75, 30), (62, 60), (72, 6), (81, 73), (73, 69), (2, 27), (44, 42),
                       (108, 45), (62, 78), (31, 72), (54, 74), (10, 49), (74, 52), (81, 91), (73, 87), (117, 32),
                       (62, 96), (45, 25), (85, 61), (31, 90), (14, 19), (65, 3), (23, 86), (55, 38), (101, 5),
                       (98, 18), (47, 34), (89, 49), (36, 43), (59, 45), (47, 52), (70, 54), (36, 61), (38, 89),
                       (111, 73), (58, 67), (9, 62), (100, 82), (28, 75), (11, 4), (92, 78), (61, 72), (112, 56),
                       (58, 85), (104, 52), (77, 98), (60, 27), (42, 77), (116, 26), (61, 90), (44, 19), (108, 22),
                       (104, 70), (62, 55), (106, 84), (74, 29), (115, 79), (116, 44), (11, 89), (44, 37), (81, 86),
                       (105, 53), (31, 67), (39, 71), (54, 69), (97, 12), (2, 40), (25, 42), (31, 85), (14, 14),
                       (74, 65), (84, 97), (106, 97), (59, 22), (51, 81), (24, 64), (43, 77), (67, 44), (90, 9),
                       (16, 60), (26, 6), (18, 2), (96, 89), (35, 73), (65, 83), (107, 98), (100, 59), (82, 23),
                       (28, 52), (46, 88), (47, 65), (57, 97), (111, 86), (94, 15), (81, 45), (60, 22), (50, 76),
                       (6, 51), (21, 49), (58, 98), (8, 79), (108, 17), (27, 92), (39, 66), (103, 69), (31, 62),
                       (54, 64), (89, 3), (13, 32), (37, 11), (14, 9), (4, 63), (106, 92), (67, 21), (59, 17), (23, 94),
                       (64, 95), (26, 1), (17, 20), (67, 39), (56, 91), (118, 84), (79, 13), (1, 75), (101, 13),
                       (5, 27), (107, 93), (48, 7), (16, 73), (99, 89), (68, 83), (29, 12), (46, 83), (111, 63),
                       (28, 47), (40, 21), (26, 86), (49, 88), (83, 1), (61, 62), (112, 46), (41, 4), (27, 69),
                       (52, 13), (116, 16), (115, 51), (8, 74), (20, 48), (2, 12), (66, 15), (114, 73), (84, 69),
                       (11, 97), (52, 98), (85, 46), (39, 79), (32, 40), (96, 43), (114, 91), (4, 58), (24, 36),
                       (84, 87), (16, 32), (59, 12), (95, 96), (87, 92), (89, 34), (76, 64), (22, 93), (45, 95),
                       (68, 60), (65, 73), (57, 69), (82, 13), (69, 43), (63, 18), (40, 16), (100, 67), (42, 44),
                       (21, 21), (80, 70), (105, 2), (42, 62), (44, 4), (85, 5), (105, 20), (0, 65), (42, 80), (2, 7),
                       (116, 29), (39, 56), (11, 74), (85, 23), (23, 48), (19, 96), (31, 70), (78, 2), (1, 29),
                       (64, 67), (89, 11), (35, 40), (59, 7), (53, 76), (118, 56), (28, 1), (56, 81), (35, 58),
                       (77, 24), (118, 74), (101, 3), (65, 68), (112, 0), (3, 93), (77, 42), (100, 44), (101, 71),
                       (46, 73), (115, 5), (15, 67), (61, 34), (104, 14), (49, 78), (21, 16), (58, 65), (104, 32),
                       (90, 97), (27, 59), (62, 35), (94, 67), (27, 77), (91, 80), (74, 9), (19, 73), (93, 22),
                       (105, 15), (11, 69), (108, 20), (8, 82), (83, 76), (4, 30), (91, 98), (32, 12), (60, 92),
                       (84, 59), (12, 52), (72, 66), (118, 33), (41, 97), (97, 10), (33, 93), (34, 58), (107, 42),
                       (35, 35), (100, 3), (72, 84), (96, 51), (1, 42), (47, 9), (64, 80), (100, 21), (119, 34),
                       (109, 88), (88, 65), (97, 95), (3, 88), (77, 37), (49, 55), (5, 30), (68, 68), (14, 97),
                       (115, 0), (61, 29), (7, 58), (104, 9), (113, 76), (115, 18), (38, 82), (19, 32), (98, 96),
                       (81, 25), (8, 41), (20, 15), (11, 46), (94, 62), (54, 26), (60, 69), (6, 98), (85, 13), (30, 77),
                       (31, 42), (4, 25), (39, 46), (11, 64), (91, 93), (20, 51), (96, 10), (107, 19), (52, 83),
                       (53, 48), (75, 85), (118, 28), (105, 95), (43, 34), (107, 37), (10, 86), (25, 84), (99, 33),
                       (72, 79), (1, 37), (37, 58), (47, 4), (107, 55), (70, 6), (53, 84), (76, 49), (77, 14), (22, 78),
                       (46, 45), (86, 81), (69, 10), (14, 74), (56, 89), (49, 50), (77, 32), (22, 96), (69, 28),
                       (9, 14), (113, 53), (67, 86), (7, 53), (70, 91), (104, 4), (110, 47), (79, 78), (71, 74),
                       (50, 51), (0, 32), (90, 87), (113, 89), (79, 96), (29, 77), (101, 96), (71, 92), (31, 19),
                       (40, 86), (60, 64), (106, 31), (39, 41), (75, 62), (102, 79), (94, 75), (4, 20), (118, 5),
                       (23, 33), (66, 13), (107, 14), (52, 78), (35, 7), (95, 58), (96, 23), (87, 54), (33, 83),
                       (10, 81), (44, 92), (96, 41), (46, 22), (22, 55), (72, 74), (56, 66), (66, 98), (3, 60),
                       (68, 40), (119, 24), (37, 71), (61, 1), (57, 49), (3, 78), (49, 45), (9, 9), (109, 96), (14, 87),
                       (55, 88), (79, 55), (27, 26), (59, 95), (19, 22), (79, 73), (102, 38), (30, 31), (48, 67),
                       (27, 44), (63, 65), (79, 91), (102, 56), (29, 72), (101, 91), (12, 1), (95, 17), (63, 83),
                       (6, 88), (29, 90), (103, 39), (75, 57), (95, 35), (118, 0), (4, 15), (114, 48), (75, 75), (1, 9),
                       (88, 14), (24, 11), (107, 27), (57, 8), (93, 92), (108, 90), (119, 1), (45, 52), (14, 46),
                       (97, 62), (100, 6), (22, 68), (68, 35), (92, 2), (65, 48), (37, 66), (57, 44), (7, 25), (69, 18),
                       (70, 81), (7, 43), (89, 94), (27, 21), (28, 84), (102, 33), (48, 62), (71, 64), (17, 93),
                       (91, 42), (114, 7), (90, 77), (60, 36), (101, 86), (102, 51), (103, 16), (75, 34), (54, 11),
                       (95, 12), (0, 40), (29, 67), (82, 91), (60, 54), (94, 47), (21, 81), (4, 10), (72, 28), (41, 59),
                       (64, 24), (107, 4), (118, 13), (45, 29), (54, 96), (65, 7), (87, 44), (16, 2), (34, 38),
                       (25, 69), (99, 18), (107, 22), (64, 60), (14, 41), (57, 21), (43, 86), (67, 53), (68, 30),
                       (14, 59), (70, 58), (18, 29), (14, 77), (55, 78), (15, 42), (78, 80), (71, 41), (26, 51),
                       (50, 18), (27, 16), (36, 83), (83, 15), (119, 99), (8, 21), (111, 95), (90, 72), (30, 21),
                       (28, 97), (102, 46), (39, 8), (41, 36), (87, 3), (60, 49), (84, 16), (106, 16), (53, 10),
                       (95, 25), (44, 41), (64, 19), (60, 67), (33, 50), (34, 15), (22, 22), (65, 2), (20, 98),
                       (76, 11), (85, 78), (15, 1), (74, 87), (76, 29), (117, 67), (89, 48), (72, 95), (14, 54),
                       (78, 57), (15, 19), (37, 56), (7, 15), (16, 82), (26, 28), (49, 30), (59, 62), (69, 8), (110, 9),
                       (70, 71), (82, 45), (19, 7), (110, 27), (29, 39), (79, 58), (30, 16), (5, 72), (63, 50),
                       (83, 28), (102, 41), (75, 24), (52, 22), (103, 6), (95, 2), (50, 98), (84, 11), (52, 40),
                       (53, 5), (112, 91), (72, 18), (75, 42), (115, 78), (95, 20), (56, 10), (72, 36), (39, 88),
                       (109, 22), (14, 13), (10, 61), (74, 64), (25, 59), (99, 8), (3, 22), (66, 60), (39, 76),
                       (65, 15), (14, 31), (23, 98), (43, 76), (13, 72), (32, 85), (96, 88), (55, 50), (78, 52),
                       (98, 30), (99, 93), (36, 55), (101, 35), (102, 0), (90, 44), (102, 18), (8, 11), (63, 45),
                       (40, 43), (9, 74), (41, 8), (69, 88), (44, 13), (63, 63), (81, 62), (9, 92), (80, 97), (44, 31),
                       (62, 67), (10, 38), (2, 34), (85, 50), (45, 14), (64, 27), (97, 24), (116, 74), (22, 30),
                       (45, 32), (31, 97), (37, 28), (97, 42), (57, 6), (43, 71), (67, 38), (66, 73), (13, 67),
                       (59, 34), (118, 83), (47, 41), (71, 8), (89, 56), (107, 92), (35, 85), (78, 65), (47, 59),
                       (48, 24), (98, 43), (111, 62), (36, 68), (59, 70), (100, 71), (119, 84), (47, 77), (48, 42),
                       (112, 45), (63, 40), (6, 45), (52, 12), (29, 47), (75, 14), (40, 56), (106, 1), (33, 17),
                       (6, 63), (87, 6), (53, 13), (93, 49), (44, 44), (2, 29), (31, 74), (34, 18), (3, 12), (12, 79),
                       (74, 72), (35, 62), (59, 29), (32, 75), (55, 40), (7, 0), (16, 67), (90, 16), (17, 32), (13, 80),
                       (118, 96), (101, 25), (24, 89), (70, 56), (88, 92), (16, 85), (71, 21), (63, 17), (100, 66),
                       (77, 64), (119, 79), (68, 95), (48, 37), (38, 91), (40, 33), (104, 36), (60, 11), (50, 65),
                       (92, 80), (84, 48), (58, 87), (80, 87), (50, 83), (6, 58), (52, 25), (2, 6), (61, 92), (81, 70),
                       (10, 28), (74, 31), (0, 82), (2, 24), (117, 11), (108, 42), (109, 7), (54, 71), (32, 34),
                       (114, 85), (43, 43), (89, 10), (106, 81), (35, 39), (59, 6), (14, 16), (24, 48), (20, 96),
                       (87, 86), (32, 70), (47, 31), (89, 46), (36, 40), (82, 7), (118, 91), (47, 49), (71, 16),
                       (99, 96), (6, 17), (111, 70), (80, 64), (77, 77), (41, 11), (33, 7), (73, 43), (10, 5), (19, 72),
                       (52, 20), (44, 16), (8, 81), (0, 77), (30, 42), (19, 90), (20, 55), (31, 64), (2, 37), (43, 38),
                       (89, 5), (85, 53), (13, 34), (12, 69), (31, 82), (78, 14), (103, 89), (4, 65), (70, 10),
                       (84, 94), (97, 27), (32, 65), (119, 33), (98, 10), (47, 26), (90, 6), (35, 70), (76, 71),
                       (100, 38), (46, 67), (37, 98), (111, 47), (58, 41), (76, 89), (63, 7), (119, 69), (46, 85),
                       (65, 98), (48, 27), (112, 30), (40, 23), (98, 95), (58, 59), (60, 1), (9, 54), (69, 68),
                       (42, 51), (18, 84), (21, 28), (112, 48), (7, 93), (10, 0), (33, 2), (116, 18), (102, 83),
                       (44, 11), (62, 47), (54, 43), (114, 57), (19, 85), (39, 63), (85, 30), (108, 32), (31, 59),
                       (94, 97), (32, 24), (24, 20), (106, 71), (89, 0), (11, 99), (66, 35), (32, 42), (78, 9),
                       (51, 55), (1, 36), (64, 74), (106, 89), (16, 34), (12, 82), (13, 47), (59, 14), (72, 96),
                       (47, 21), (17, 35), (58, 36), (104, 3), (28, 44), (68, 80), (38, 76), (61, 41), (21, 5),
                       (111, 60), (77, 67), (27, 48), (73, 15), (115, 30), (101, 95), (80, 72), (105, 4), (20, 27),
                       (93, 11), (54, 38), (20, 45), (83, 83), (43, 10), (75, 79), (30, 89), (8, 89), (11, 76),
                       (54, 56), (41, 86), (23, 50), (74, 34), (51, 32), (20, 63), (103, 79), (13, 24), (4, 55),
                       (95, 75), (55, 2), (96, 40), (114, 88), (84, 84), (67, 13), (34, 65), (25, 96), (99, 45),
                       (72, 91), (55, 20), (118, 58), (87, 89), (65, 52), (34, 83), (57, 48), (45, 92), (28, 21),
                       (14, 86), (111, 37), (112, 2), (17, 30), (100, 46), (49, 62), (6, 2), (15, 69), (38, 71),
                       (57, 84), (98, 85), (77, 62), (90, 81), (50, 45), (6, 20), (69, 58), (19, 39), (101, 90),
                       (79, 90), (73, 28), (19, 57), (93, 6), (11, 53), (85, 2), (94, 69), (54, 33), (114, 47),
                       (83, 78), (106, 43), (43, 5), (39, 53), (35, 1), (11, 71), (0, 80), (1, 8), (84, 61), (66, 25),
                       (12, 54), (32, 32), (23, 63), (64, 64), (65, 29), (10, 93), (88, 31), (107, 44), (56, 60),
                       (99, 40), (100, 5), (106, 79), (119, 18), (1, 44), (56, 78), (53, 91), (99, 58), (9, 3),
                       (45, 87), (86, 88), (77, 21), (37, 83), (111, 32), (15, 46), (57, 61), (56, 96), (89, 93),
                       (98, 80), (90, 76), (19, 34), (110, 54), (61, 49), (82, 72), (39, 12), (30, 43), (113, 96),
                       (90, 94), (63, 77), (19, 52), (102, 68), (39, 30), (29, 84), (0, 57), (43, 0), (103, 51), (1, 3),
                       (43, 18), (16, 1), (118, 30), (96, 30), (10, 88), (56, 55), (106, 74), (22, 62), (68, 29),
                       (118, 48), (14, 58), (58, 3), (3, 67), (77, 16), (22, 80), (68, 47), (109, 85), (37, 78),
                       (69, 12), (38, 43), (22, 98), (42, 13), (101, 62), (98, 75), (104, 6), (49, 70), (58, 39),
                       (73, 0), (42, 31), (110, 49), (79, 80), (102, 45), (8, 38), (71, 76), (18, 82), (42, 49),
                       (20, 12), (79, 98), (39, 25), (102, 63), (54, 23), (94, 59), (63, 90), (95, 24), (41, 53),
                       (84, 33), (6, 95), (103, 46), (75, 64), (118, 7), (23, 35), (114, 55), (88, 3), (75, 82),
                       (52, 80), (99, 12), (72, 58), (2, 79), (85, 95), (68, 24), (47, 1), (76, 46), (68, 42),
                       (109, 80), (78, 74), (111, 22), (97, 87), (77, 29), (89, 83), (78, 92), (71, 53), (30, 15),
                       (26, 63), (19, 24), (82, 62), (62, 4), (103, 5), (48, 69), (8, 33), (73, 13), (19, 42), (83, 45),
                       (11, 38), (106, 28), (75, 59), (96, 2), (114, 50), (87, 33), (116, 78), (76, 5), (108, 74),
                       (45, 36), (88, 16), (65, 14), (34, 45), (33, 80), (108, 92), (68, 19), (119, 3), (14, 48),
                       (34, 63), (66, 95), (22, 70), (86, 73), (15, 31), (97, 82), (24, 98), (49, 42), (36, 72),
                       (42, 3), (79, 52), (102, 17), (98, 65), (8, 10), (30, 10), (113, 63), (90, 61), (50, 25),
                       (19, 19), (36, 90), (27, 23), (30, 28), (40, 60), (114, 9), (20, 2), (6, 67), (21, 65), (40, 78),
                       (104, 81), (52, 52), (40, 96), (64, 26), (73, 93), (106, 41), (2, 51), (96, 15), (87, 46),
                       (65, 9), (10, 73), (74, 76), (37, 27), (2, 69), (108, 87), (109, 52), (22, 47), (15, 8),
                       (38, 10), (98, 24), (66, 90), (26, 17), (113, 22), (77, 1), (59, 51), (32, 97), (78, 64),
                       (24, 93), (80, 6), (98, 42), (67, 73), (90, 38), (113, 40), (69, 15), (82, 34), (49, 37),
                       (119, 83), (102, 12), (71, 43), (8, 5), (48, 41), (91, 21), (100, 88), (9, 68), (19, 14),
                       (79, 65), (28, 81), (71, 61), (112, 62), (30, 23), (0, 19), (40, 55), (114, 4), (91, 39),
                       (60, 33), (102, 48), (6, 62), (21, 60), (83, 53), (75, 49), (62, 79), (105, 59), (39, 95),
                       (85, 62), (1, 1), (10, 68), (74, 71), (2, 64), (45, 44), (68, 9), (86, 45), (85, 80), (78, 41),
                       (38, 5), (51, 87), (12, 96), (89, 50), (85, 98), (118, 95), (78, 59), (101, 24), (47, 53),
                       (24, 88), (55, 57), (36, 62), (79, 42), (61, 6), (70, 73), (71, 38), (119, 78), (90, 51),
                       (63, 34), (27, 13), (79, 60), (11, 5), (29, 41), (111, 92), (94, 21), (17, 85), (40, 50),
                       (8, 18), (83, 30), (29, 59), (6, 57), (9, 99), (87, 0), (106, 13), (21, 73), (4, 2), (72, 20),
                       (74, 48), (115, 98), (53, 25), (2, 41), (56, 12), (108, 59), (109, 24), (105, 72), (54, 88),
                       (85, 57), (74, 66), (93, 79), (108, 77), (109, 42), (74, 84), (51, 82), (49, 9), (32, 87),
                       (38, 18), (118, 90), (97, 67), (71, 15), (26, 25), (113, 30), (78, 72), (28, 53), (119, 73),
                       (70, 68), (55, 70), (48, 31), (5, 69), (102, 20), (47, 84), (119, 91), (21, 32), (58, 81),
                       (40, 45), (52, 19), (61, 86), (105, 31), (60, 41), (73, 60), (6, 70), (72, 15), (30, 98),
                       (73, 78), (54, 83), (51, 59), (23, 77), (20, 90), (84, 93), (2, 54), (66, 57), (12, 86),
                       (14, 28), (37, 30), (74, 79), (97, 44), (98, 9), (3, 37), (16, 56), (113, 7), (7, 7), (16, 74),
                       (90, 23), (76, 88), (59, 54), (79, 32), (1, 94), (63, 24), (36, 70), (83, 2), (60, 0), (69, 67),
                       (38, 98), (94, 11), (21, 27), (80, 76), (17, 75), (100, 91), (60, 18), (5, 82), (92, 87),
                       (6, 47), (69, 85), (61, 81), (112, 65), (58, 94), (81, 59), (105, 26), (44, 10), (33, 19),
                       (80, 94), (42, 86), (25, 15), (27, 88), (44, 28), (72, 10), (10, 35), (25, 33), (2, 31),
                       (11, 98), (45, 11), (108, 49), (31, 76), (86, 12), (32, 41), (23, 72), (84, 88), (106, 88),
                       (59, 13), (14, 23), (78, 26), (4, 77), (24, 55), (95, 97), (43, 68), (66, 70), (113, 2),
                       (67, 35), (99, 67), (59, 31), (118, 80), (28, 25), (101, 9), (47, 38), (48, 3), (65, 74),
                       (17, 34), (70, 40), (59, 49), (98, 22), (79, 9), (46, 79), (28, 43), (47, 56), (71, 23),
                       (16, 87), (112, 24), (96, 98), (36, 65), (49, 84), (9, 48), (28, 61), (68, 97), (119, 81),
                       (6, 24), (94, 6), (40, 35), (63, 37), (100, 86), (60, 13), (115, 47), (62, 41), (80, 89),
                       (104, 56), (8, 70), (10, 12), (42, 81), (116, 30), (25, 10), (44, 23), (62, 59), (8, 88),
                       (10, 30), (2, 26), (22, 4), (12, 58), (31, 71), (95, 74), (103, 78), (74, 51), (24, 32),
                       (106, 83), (3, 9), (67, 12), (109, 27), (31, 89), (32, 54), (70, 17), (47, 15), (118, 75),
                       (78, 39), (90, 13), (35, 77), (92, 41), (65, 87), (48, 16), (58, 48), (63, 14), (49, 79),
                       (9, 43), (6, 19), (92, 59), (112, 37), (61, 53), (94, 1), (21, 17), (49, 97), (104, 33), (52, 4),
                       (116, 7), (44, 0), (104, 51), (54, 32), (27, 78), (105, 16), (42, 76), (2, 3), (85, 19),
                       (81, 67), (94, 86), (0, 79), (74, 28), (19, 92), (83, 95), (117, 8), (73, 63), (86, 2), (0, 97),
                       (74, 46), (97, 11), (66, 42), (67, 7), (86, 20), (59, 3), (31, 84), (13, 36), (95, 87), (87, 83),
                       (67, 25), (17, 6), (96, 70), (119, 35), (1, 61), (65, 64), (107, 79), (17, 24), (76, 73),
                       (77, 38), (36, 37), (9, 20), (71, 13), (38, 65), (40, 7), (80, 43), (77, 56), (50, 39), (92, 54),
                       (38, 83), (57, 96), (7, 77), (40, 25), (26, 90), (90, 93), (93, 0), (39, 29), (50, 75), (0, 56),
                       (73, 40), (93, 18), (116, 20), (94, 81), (66, 19), (103, 68), (94, 99), (95, 64), (0, 92),
                       (97, 6), (43, 35), (67, 2), (103, 86), (53, 67), (72, 80), (4, 62), (23, 75), (64, 76), (43, 53),
                       (16, 36), (34, 72), (100, 17), (118, 65), (47, 23), (16, 54), (36, 32), (111, 44), (17, 37),
                       (58, 38), (40, 2), (26, 67), (9, 33), (115, 14), (61, 43), (21, 7), (69, 65), (101, 97), (8, 55),
                       (63, 89), (18, 99), (20, 29), (11, 60), (85, 9), (8, 73), (91, 89), (114, 54), (20, 47),
                       (60, 83), (35, 8), (118, 24), (114, 72), (106, 68), (107, 33), (75, 99), (99, 29), (96, 42),
                       (64, 71), (70, 2), (87, 73), (107, 51), (89, 15), (72, 93), (34, 85), (17, 14), (9, 10),
                       (119, 43), (92, 26), (86, 95), (111, 39), (3, 97), (26, 62), (113, 67), (29, 6), (15, 71),
                       (73, 12), (42, 43), (19, 41), (101, 92), (82, 79), (7, 85), (81, 34), (71, 88), (105, 1),
                       (63, 84), (91, 66), (93, 8), (39, 37), (75, 58), (95, 36), (60, 78), (66, 9), (20, 42), (24, 79),
                       (31, 51), (114, 67), (87, 50), (13, 21), (53, 57), (72, 70), (119, 2), (33, 97), (56, 62),
                       (22, 69), (47, 13), (99, 60), (9, 5), (117, 96), (28, 18), (92, 21), (65, 67), (86, 90),
                       (61, 15), (111, 34), (7, 44), (3, 92), (26, 57), (58, 28), (97, 99), (18, 53), (101, 69),
                       (80, 46), (47, 98), (7, 62), (113, 80), (79, 87), (62, 16), (30, 45), (94, 48), (54, 12),
                       (27, 58), (23, 6), (91, 61), (48, 99), (94, 66), (30, 63), (54, 30), (8, 63), (21, 82),
                       (106, 40), (11, 68), (107, 5), (52, 69), (44, 65), (118, 14), (24, 7), (88, 10), (35, 16),
                       (1, 23), (88, 28), (56, 57), (57, 22), (3, 51), (22, 64), (64, 79), (14, 60), (34, 75), (56, 75),
                       (50, 1), (68, 49), (36, 91), (15, 43), (97, 94), (98, 59), (58, 23), (77, 36), (49, 54), (3, 87),
                       (69, 32), (38, 63), (98, 77), (81, 6), (73, 2), (18, 66), (82, 69), (0, 18), (28, 98), (62, 11),
                       (101, 82), (39, 9), (54, 7), (7, 75), (63, 74), (82, 87), (20, 14), (110, 69), (6, 79), (12, 10),
                       (94, 61), (4, 6), (91, 74), (23, 19), (41, 55), (83, 70), (31, 23), (52, 64), (21, 95), (23, 37),
                       (64, 38), (56, 34), (53, 47), (87, 58), (88, 23), (37, 39), (56, 52), (57, 17), (105, 94),
                       (76, 30), (64, 56), (49, 13), (86, 62), (37, 57), (15, 20), (2, 99), (49, 31), (113, 34), (5, 6),
                       (26, 29), (68, 44), (97, 89), (98, 54), (80, 18), (110, 28), (55, 92), (79, 59), (98, 72),
                       (30, 17), (26, 65), (90, 68), (63, 51), (59, 99), (19, 26), (28, 93), (102, 42), (11, 22),
                       (54, 2), (90, 86), (94, 38), (114, 16), (40, 67), (84, 12), (11, 40), (6, 74), (48, 89),
                       (72, 19), (41, 50), (114, 34), (83, 65), (106, 30), (10, 62), (107, 13), (56, 29), (35, 6),
                       (76, 7), (108, 76), (96, 22), (1, 13), (88, 18), (33, 82), (2, 76), (76, 25), (66, 79), (85, 92),
                       (93, 96), (32, 86), (111, 1), (38, 17), (97, 66), (66, 97), (77, 8), (92, 6), (69, 4), (97, 84),
                       (7, 29), (70, 67), (67, 80), (27, 7), (86, 93), (42, 5), (55, 87), (82, 41), (101, 54),
                       (113, 65), (91, 28), (59, 94), (110, 41), (19, 21), (103, 2), (71, 68), (17, 97), (40, 62),
                       (41, 27), (9, 93), (83, 42), (48, 84), (95, 16), (40, 80), (63, 82), (106, 25), (84, 25),
                       (21, 85), (62, 86), (45, 15), (33, 59), (56, 24), (107, 8), (53, 37), (99, 4), (44, 68),
                       (25, 55), (105, 84), (64, 46), (34, 42), (74, 78), (37, 47), (38, 12), (24, 77), (77, 3),
                       (26, 19), (86, 70), (35, 86), (67, 57), (15, 28), (113, 24), (1, 93), (47, 60), (71, 27),
                       (67, 75), (27, 2), (89, 75), (78, 84), (70, 80), (30, 7), (90, 58), (0, 3), (27, 20), (110, 36),
                       (28, 83), (111, 99), (58, 93), (60, 35), (5, 99), (106, 2), (115, 69), (44, 27), (40, 75),
                       (114, 24), (87, 7), (60, 53), (106, 20), (6, 82), (52, 49), (25, 32), (53, 14), (72, 27),
                       (20, 84), (3, 13), (25, 50), (108, 66), (22, 26), (34, 37), (97, 38), (93, 86), (86, 47),
                       (46, 11), (78, 43), (74, 91), (57, 20), (70, 39), (43, 85), (18, 10), (24, 90), (70, 57),
                       (7, 19), (16, 86), (55, 77), (79, 44), (47, 73), (71, 40), (82, 49), (52, 8), (47, 91), (94, 23),
                       (21, 39), (58, 88), (5, 94), (29, 61), (21, 57), (81, 71), (104, 73), (73, 67), (33, 31),
                       (52, 44), (2, 25), (53, 9), (81, 89), (87, 20), (32, 83), (62, 94), (85, 59), (3, 8), (86, 24),
                       (37, 19), (31, 88), (54, 90), (2, 61), (3, 26), (85, 77), (15, 0), (97, 51), (70, 34), (49, 11),
                       (16, 63), (18, 5), (32, 89), (101, 21), (1, 83), (16, 81), (90, 30), (110, 8), (82, 26),
                       (46, 91), (47, 68), (71, 35), (16, 99), (48, 33), (36, 77), (9, 60), (49, 96), (83, 9), (11, 2),
                       (94, 18), (50, 79), (83, 27), (69, 92), (52, 21), (116, 24), (61, 88), (112, 72), (50, 97),
                       (73, 62), (52, 39), (2, 20), (53, 4), (39, 69), (2, 38), (86, 19), (109, 21), (86, 37), (68, 1),
                       (51, 79), (1, 60), (32, 84), (88, 83), (71, 12), (90, 25), (63, 8), (18, 18), (76, 90), (59, 56),
                       (5, 48), (71, 30), (91, 8), (49, 91), (82, 39), (119, 88), (92, 71), (77, 73), (111, 84),
                       (112, 49), (40, 42), (80, 78), (105, 10), (33, 21), (93, 35), (85, 31), (54, 62), (73, 75),
                       (74, 40), (93, 53), (39, 82), (108, 51), (103, 85), (85, 49), (12, 65), (23, 74), (20, 87),
                       (86, 32), (13, 48), (4, 79), (109, 34), (35, 48), (97, 41), (98, 6), (67, 37), (17, 18),
                       (35, 66), (4, 97), (55, 44), (119, 47), (78, 46), (70, 42), (107, 91), (90, 20), (76, 85),
                       (119, 65), (1, 91), (17, 54), (91, 3), (40, 19), (77, 68), (29, 28), (15, 93), (94, 8), (40, 37),
                       (81, 38), (92, 84), (42, 65), (104, 58), (41, 20), (74, 17), (20, 46), (39, 59), (44, 25),
                       (108, 28), (105, 41), (8, 90), (73, 70), (114, 71), (43, 29), (109, 11), (13, 25), (32, 38),
                       (74, 53), (43, 47), (107, 50), (106, 85), (13, 43), (59, 10), (55, 21), (1, 50), (64, 88),
                       (13, 61), (99, 64), (4, 92), (111, 38), (48, 0), (90, 15), (82, 11), (9, 27), (6, 3), (29, 5),
                       (92, 43), (40, 14), (50, 46), (29, 23), (92, 61), (21, 19), (104, 35), (73, 29), (6, 39),
                       (52, 6), (42, 60), (69, 77), (115, 44), (8, 67), (54, 34), (27, 80), (50, 82), (91, 83),
                       (81, 51), (25, 7), (66, 8), (102, 92), (27, 98), (114, 66), (75, 93), (0, 99), (51, 46),
                       (114, 84), (23, 64), (96, 36), (16, 25), (12, 73), (35, 38), (36, 3), (4, 69), (53, 74),
                       (72, 87), (59, 5), (89, 27), (56, 79), (35, 56), (117, 95), (59, 23), (99, 59), (96, 72),
                       (36, 21), (65, 66), (45, 88), (36, 39), (100, 42), (77, 40), (28, 35), (119, 55), (115, 3),
                       (111, 51), (57, 80), (40, 9), (29, 18), (15, 83), (81, 28), (90, 95), (73, 24), (113, 97),
                       (115, 39), (116, 4), (30, 62), (25, 2), (83, 74), (116, 22), (62, 51), (94, 83), (83, 92),
                       (43, 19), (84, 57), (75, 88), (52, 86), (35, 15), (4, 46), (118, 31), (95, 66), (97, 8),
                       (41, 95), (33, 91), (16, 20), (43, 37), (106, 75), (99, 36), (13, 33), (55, 11), (53, 69),
                       (64, 78), (106, 93), (38, 44), (34, 92), (17, 21), (99, 72), (100, 37), (65, 79), (15, 60),
                       (112, 11), (98, 76), (81, 5), (26, 69), (40, 4), (68, 84), (62, 10), (73, 19), (18, 83),
                       (110, 68), (62, 28), (11, 44), (71, 95), (63, 91), (51, 0), (19, 66), (62, 46), (75, 65),
                       (102, 82), (4, 23), (0, 71), (114, 56), (74, 20), (91, 91), (106, 52), (84, 52), (72, 59),
                       (114, 74), (87, 57), (43, 32), (4, 59), (118, 44), (88, 40), (36, 11), (65, 56), (111, 23),
                       (56, 87), (57, 52), (58, 17), (49, 48), (109, 99), (69, 26), (80, 35), (3, 99), (26, 64),
                       (113, 69), (18, 60), (42, 27), (38, 75), (15, 73), (101, 94), (103, 24), (8, 52), (23, 13),
                       (82, 99), (60, 62), (39, 39), (85, 6), (75, 60), (21, 89), (4, 18), (91, 86), (20, 44), (84, 47),
                       (103, 60), (72, 54), (118, 21), (23, 49), (105, 88), (88, 17), (53, 59), (1, 30), (77, 7),
                       (14, 67), (80, 12), (76, 60), (49, 43), (5, 18), (69, 21), (86, 92), (38, 52), (68, 56),
                       (37, 87), (7, 46), (80, 30), (89, 97), (6, 1), (42, 22), (115, 6), (18, 55), (61, 35), (7, 64),
                       (98, 84), (26, 77), (90, 80), (27, 42), (81, 13), (42, 40), (8, 29), (110, 58), (109, 1),
                       (30, 29), (62, 18), (94, 50), (83, 59), (106, 24), (102, 72), (52, 53), (75, 55), (94, 68),
                       (31, 30), (23, 26), (41, 62), (66, 6), (106, 42), (103, 55), (44, 67), (118, 16), (41, 80),
                       (34, 41), (107, 25), (93, 90), (116, 92), (45, 50), (118, 34), (1, 25), (96, 34), (10, 92),
                       (16, 23), (117, 75), (109, 71), (92, 0), (65, 46), (67, 74), (50, 3), (5, 13), (78, 83),
                       (38, 47), (97, 96), (98, 61), (70, 79), (26, 54), (50, 21), (59, 88), (19, 15), (36, 86),
                       (69, 34), (102, 31), (42, 17), (81, 8), (48, 60), (91, 40), (73, 4), (18, 68), (82, 71),
                       (101, 84), (39, 11), (71, 80), (54, 9), (95, 10), (0, 38), (63, 76), (40, 74), (83, 54),
                       (84, 19), (11, 47), (52, 48), (102, 67), (31, 25), (4, 8), (6, 99), (21, 97), (44, 62), (87, 42),
                       (10, 69), (35, 13), (25, 67), (108, 83), (22, 43), (10, 87), (33, 89), (22, 61), (98, 38),
                       (59, 65), (38, 42), (61, 7), (97, 91), (101, 43), (55, 76), (89, 87), (27, 14), (67, 87),
                       (50, 16), (42, 12), (110, 30), (101, 61), (8, 19), (94, 22), (90, 70), (27, 32), (36, 99),
                       (19, 28), (17, 86), (30, 19), (92, 98), (83, 31), (8, 37), (94, 40), (112, 76), (102, 44),
                       (41, 34), (40, 69), (60, 47), (84, 14), (20, 11), (71, 75), (31, 2), (4, 3), (40, 87), (105, 55),
                       (84, 32), (6, 94), (115, 99), (53, 26), (72, 39), (108, 60), (87, 37), (10, 64), (34, 31),
                       (53, 44), (46, 5), (64, 53), (10, 82), (51, 83), (34, 49), (56, 49), (25, 80), (45, 58), (3, 61),
                       (49, 28), (90, 29), (109, 79), (69, 6), (78, 73), (79, 38), (19, 5), (119, 92), (30, 14),
                       (48, 50), (0, 10), (82, 61), (5, 88), (103, 4), (9, 95), (20, 6), (106, 9), (29, 73), (6, 71),
                       (53, 3), (115, 76), (21, 69), (105, 50), (60, 60), (33, 43), (106, 27), (6, 89), (4, 16),
                       (62, 88), (45, 17), (64, 30), (54, 84), (118, 1), (74, 62), (34, 26), (25, 57), (116, 77),
                       (37, 13), (108, 73), (85, 71), (97, 45), (76, 22), (67, 41), (49, 5), (3, 38), (14, 47),
                       (51, 96), (57, 27), (7, 8)}
                      ))

    def test_02_angelca(self):
        zemljevid = preberi_zemljevid("dravlje.txt")

        self.assertEqual(1, angelca(1, 1, "r", zemljevid))  # (1, 1) -> (0, 1)
        # Če spodnji test ne deluje, je šel na napačni r
        self.assertEqual(10, angelca(1, 1, "rc", zemljevid))  # (1, 1) -> (0, 1) -> (8, 0)
        self.assertEqual(15, angelca(1, 1, "rcr", zemljevid))  # ... -> (5, 2)
        self.assertEqual(21, angelca(1, 1, "rcrr", zemljevid))  # ... -> (1, 0)
        # Če spodnji test na deluje (ker funkcija vrne 30 namesto 31), je šel mogoče
        # v prejšnjem zgoraj na r na (0, 1), kjer je že bil
        self.assertEqual(31, angelca(1, 1, "rcrrc", zemljevid))  # ... -> (11, 0)
        self.assertEqual(38, angelca(1, 1, "rcrrca", zemljevid))  # ... -> (9, 5)
        self.assertEqual(41, angelca(1, 1, "rcrrcal", zemljevid))  # ... -> (7, 4)
        self.assertEqual(41, angelca(1, 1, "rcrrcalr", zemljevid))  # ... -> se ustavi, ni več r-jev
        self.assertEqual(41, angelca(1, 1, "rcrrcalrd", zemljevid))  # ... -> se ustavi, ni več r-jev
        self.assertEqual(41, angelca(1, 1, "rcrrcalrdg", zemljevid))  # ... -> se ustavi, ni več r-jev

        self.assertEqual(0, angelca(0, 0, "", zemljevid))
        self.assertEqual(1, angelca(0, 0, "r", zemljevid))
        self.assertEqual(3, angelca(0, 0, "rp", zemljevid))
        self.assertEqual(5, angelca(0, 0, "rpr", zemljevid))
        self.assertEqual(7, angelca(0, 0, "rprb", zemljevid))
        self.assertEqual(11, angelca(0, 0, "rprbr", zemljevid))

        self.assertEqual(0, angelca(0, 5, "", zemljevid))
        self.assertEqual(1, angelca(0, 5, "a", zemljevid))
        self.assertEqual(2, angelca(0, 5, "as", zemljevid))
        self.assertEqual(11, angelca(0, 5, "asa", zemljevid))
        self.assertEqual(14, angelca(0, 5, "asal", zemljevid))
        self.assertEqual(14, angelca(0, 5, "asala", zemljevid))
        self.assertEqual(14, angelca(0, 5, "asalag", zemljevid))

class Test08(NoWarningTest):
    def test_01_johanca(self):
        zemljevid = preberi_zemljevid("dravlje.txt")

        self.assertEqual("b", johanca(1, 1, ">", zemljevid))
        self.assertEqual("", johanca(1, 1, "", zemljevid))
        self.assertEqual("b", johanca(1, 1, "><>", zemljevid))
        self.assertEqual("bd", johanca(1, 1, "><>4v", zemljevid))
        self.assertEqual("bd", johanca(1, 1, "><>4v^", zemljevid))
        self.assertEqual("bd", johanca(1, 1, "><>4v^12^", zemljevid))
        self.assertEqual("bd", johanca(1, 1, "><>4v^12^13v", zemljevid))
        self.assertEqual("bda", johanca(1, 1, "><>4v^12^13v1<", zemljevid))
        self.assertEqual("bda", johanca(1, 1, "><>4v^12^13v1<2^", zemljevid))
        self.assertEqual("bda", johanca(1, 1, "><>4v^12^13v1<2^>>>>>>", zemljevid))
        self.assertEqual("bda", johanca(1, 1, "><>4v^12^13v1<2^>>>>>>", zemljevid))
        self.assertEqual("bda", johanca(1, 1, "><>4v^12^13v1<2^>>>>>>2v", zemljevid))
        self.assertEqual("bdal", johanca(1, 1, "><>4v^12^13v1<2^>>>>>>2v^", zemljevid))
        self.assertEqual("bdall", johanca(1, 1, "><>4v^12^13v1<2^>>>>>>2v^4v4<^", zemljevid))

        self.assertEqual("b", johanca(1, 1, "473857<473858>", zemljevid))

class Test09(NoWarningTest):
    def test_01_angelca(self):
        start = time.time()
        zemljevid = preberi_zemljevid("bezigrad.txt")
        self.assertEqual(
            583,
            angelca(50, 50,
                    "sacapbldglldagardsdapladdcsrrssbragtbdrrgaptclcldagaatbdgpaasasctprdclbplbdabclgslrggrlstpbccgspdgagrggsdtgp",
                    zemljevid))

        self.assertEqual(32111,
            angelca(50, 50,
                    "sdgasbracbcltrslrcrsdbgbgbptaddppdtlbllapbggarrasbsttddrgtrdggtrcrrtslcrgrlrrscbtbarracacdcgscdrpt"
                    "tcsbgldcpltcbgsbctdltlcbtrppasgtpbrragscpalarddrsbgtgsbdbrcpcggpllappglbrbpacdatggtrragcgdrgtbslds"
                    "asrcbpcraagslsgrtdbagatsrcdrargddadrdrtrdtdbpbaaaddrddsglltpsbsattglrgsadrdrlsalslplssltcddbscpdls"
                    "aggdatlbpscrgaclgrbbdpaaaraclpsltgcdsddbbcbpltbabsldgttgcsbacbdrddrdrbslbgcdpppbtslptgpcgldgcrppab"
                    "lbatbgtapsdbpgacgrlscsrggscdbgbpbaldasbgdllactpccstbatltadbltbctbprtpdccptasbagtlgllrlpbdsgcprbrcs"
                    "sllbtpgcgagsrgtdpcbrttpbdblsbdcsgplrpsbgprgscpbbpbadtbdadrdtggcrppalsprsrltdgprasglgldcbcrdtpasrbl"
                    "csdcdprrsspgtppccblddrlpptdplpassbtbgclcagtpcbscpbdgdrdapclctttraaatpgptlclbsartttagsbrtbgtcdbtadb"
                    "gbldglclrlbbrcargcdgrbbcbgcssddpsatrrlpsgpalattdlldtdgdrprsgrrsgcsccargglpcdsdtdcsrbdppssrtsrrcbrg"
                    "grlcbgpsbsdgaprstglpaprdrsdpbtlbpcdpgagldagclrllbrdstaltbpldbtcgbcarlargcdcpclrcrsbrgrtpgscbaabsdr"
                    "asggaaprcsagbtdrgtpcltcrcrtcsdrbccbtllgcdgdrtlptdrtrgdbbptbpgrprsalbprrardlrcgabbtadpcdbltgbbpabdl"
                    "dspgltabasrgbdrrgcasccsbrtllppsadbcgaddcdrblsbbprsrcdrpsdlpdglslaalcblgldrlrtabbgbttalcdgcpdrsdagc"
                    "llldrpspapptapbaprpbaappgtdrgcgccppttdrcsbrcrtdbdppaasddtccgtblplbcpclrbbbatcbggsdbdldbpblarllablb"
                    "rbgdprtbaaadacgsrcdcbgtlbbarrstcbtalatbbbtpsdpgcacgtdldasgtbbcapsbdgbclsatappcdgrattabarasasrarbtp"
                    "dlssallsalsbsdbggbgbcpbrrctdassgspbbbtbtpapctcalgdsrcbdcctatdldrtcltpsdcbsblbttlbbrsbgcaltapatcttg"
                    "sbddbbrdbgsgbsldgsattrbtacsctcrlspllrraapggadacltsgrggbttgrgrsdtrpdpabbtgtclrttpralgprpaddptcgdcgt"
                    "agrsratrdttgslltbbcrtrbptldcgadlttbdddbdgpagscrgbbcaptdrtdpspppbpcsbbapbbasdggpsltspdslpacgdrsdltl"
                    "ddcgbbppsglblrrlagtpgpagssdtctcptcscbasbcpcadtcptrrstasplgtdcbbdpacgaalgspdsrcpgbarsldssstpclabrtr"
                    "cbrpgccspadrcllcgtppltslsgbgsrpptcrplalspcbpagdsgctracpcbbsapdsrbdsrgttltatpspssldastggtllbldsccbr"
                    "bltdgpcbgppdasdtdscsssgplrrlrccdpdrlltccascdspgbcgppcpsltsbardagsadlpcgaasrttrrctcpsradtrdapatasrp"
                    "tsrdrbspggcglsaapgsaprrddtlggsbrctbdpadbtrtddalpblagdlsctaaspalaslrdgadpbaplddbbplgbbdtptbdrrtcgaa"
                    "sbbrdttpbctlrcltlcassdprdtdbbdbcaccppbacggapppbagbrrrcbsltgadlcdglasprcldbtbdrsplgbgddrgdsdgdglpbr"
                    "trgslccgssbgbbttrltrgddrgrcadcdprstalrdadtadgrcgacbtadlgcddcblbssdtscbcbrlrbblrbsrlgdpsrgrrrpddltb"
                    "ddbbprgssbtrgragbpblpcsbdgddarsssdttastlsgtrrttpsdsspasrdtttdclrprpsdladdllbscbrtgbstrbpggsgtcrggt"
                    "abgacgptagbcbdsbrsscaaspclcbgasdcdggrrspcddtcgpcpagsrttcsgtdarbrsgttbddttgaprlagcdslaaplscssaddsgs"
                    "pctsprdlgldbpbaadgrgadbclllgdtpcgglatbdagbtrrlrgrgctlllralgabdrtlacpcpttllscrgdacdbt",
                    zemljevid)
        )
        self.assertLess(time.time() - start, 2, "Funkcija je prepočasna.")

    def test_02_johanca(self):
        start = time.time()

        zemljevid = preberi_zemljevid("bezigrad.txt")
        self.assertEqual(
            "sacapbldglldagardsdapladdcsrrssbragtbdrrgaptclcldagaatbdgpaasasctprdclbplbdabclgslrggrlstpbccgspdgagrggsdtgp",
            johanca(50, 50,
                    "^v><^<^11v>^<<1v^^>v>^^v>9v^vv13>>>>12^1^^^13^>^>>10<>vv<3^^^12<<8>^10^>7>3<"
                    "^^^10>^>2v>3>12<v><^5^<>v4^<v^>v^<>>>^><<13^^8^><>><v<>^6>^^12<^<<3^<^v11<"
                    "10<v8<6>2>^^>>v2>^>vvv11<<7^><><><v11>6>><v<12<13>v<<12<^<>v>^<v6<v8<^v^8v11v"
                    "v6^>^>^<<^>^5^<>^v<^8>v^<>>>13><><^2v12v>vv^>>v2><<v^<vvv11>v>><v<><vv<^8<<"
                    "12v6<>^4^^1>4>13^12^vvv^vv^13>v<<>>7v<vv10^v^<>>^v^^^<v7>v<6<8>>>1v7<6v>^^9>"
                    "^10^vv>>^<3vvv1v4^^^^>9<^v3<11vv9v9>2<9v>>>vvv13<1v11^v<9<v<v^>5^>5v<13<2v<>"
                    "11^><11^v<>>5v1>v^v2v<^^^>1^8v11>v6>v3^v^^^<12v<4^7^v4vv^<<>13vv<<1v12<vv<v<>v"
                    "<vvv10<^^^v10v^>10^v7v7<v4v5^8>3<v<^>5^<9><<><<>13v>v4>>>9^>v^<v1v3v6<>><^^>v>"
                    "^7>^v^v>>>^>12^7^v3^12>v^6<^7>3v8^>v6>2><6>v6^1>vv>^^4>9v><^vv2>>>8^>^4>>vvv^^"
                    "v><>><>v>v^10<^^7v10v^v>^>^^^1^<>11v^vv13v^v<v^vv13<7<>^v^5^^<<^<v>1>>>>v<<<10>"
                    "><<2^<10<v11^<<^>v7^<1v12^v4^<<v>13v^v^^<13>v<>4v<4^^^13>>13>v^vvvv><7^^<12^>><^"
                    "^v^^vv10>^10<^>>8<vv>v2<9<7v1vv^>^^<vv<10v>>>4>v>>>1>5<>v9>10v<v>6^<v>^><v9^5vv^>"
                    "<v7v>v^10vv11<12^^^<<>3>10>13>>^v<>><>9>><^^v><2<><^<>v1^<^v^<9v8>^3v<11v<v10vv^<8"
                    "<13^7<1>><^<v<vv<>12>5v7<2v10>5<12>>>^>v9<<<1>v^v4>^^^><<<^^vvv<^<^^8^>>v^v^7v^6v<"
                    "^3<<<8<<^>^<>^^>>vv13^>9>><<13^>^^>^>^>2v><^1<>4>6v<^<<<5vv^7<11>>4^<11<<^11vv7^3<11v"
                    "10v>2^<13v>>^<>^>>6^<11v>>v<v<3v<8^12v4^1v8^v1<12v5^13<3v6<>10>9<vv<<v5<>2>>^<10^6vv^"
                    "<<>12><>>13^7v6^<>>10>vv10>10^^<8>><^>^^^1v3>v2<<>1^13>2>^v<11v>>>v2>>3^<2>^9^>^1v>^"
                    "13<^>^^8v<>>5<><>>^v<^v9<v>>",
                    zemljevid))
        self.assertLess(time.time() - start, 1, "Funkcija je prepočasna.")

    def test_najboljsa_cetrt(self):
        zemljevid = preberi_zemljevid("dravlje.txt")
        self.assertEqual((0, 4), najboljsa_cetrt(4, zemljevid))
        self.assertEqual((1, 4), najboljsa_cetrt(2, zemljevid))

        zemljevid = preberi_zemljevid("bezigrad.txt")
        self.assertEqual((31, 82), najboljsa_cetrt(4, zemljevid))
        self.assertEqual((2, 37), najboljsa_cetrt(2, zemljevid))

        start = time.time()
        self.assertEqual((31, 39), najboljsa_cetrt(50, zemljevid))
        self.assertLess(time.time() - start, 3, "Funkcija je prepočasna.")

        start = time.time()
        self.assertEqual((31, 82), najboljsa_cetrt(10, zemljevid))
        self.assertLess(time.time() - start, 3, "Funkcija je prepočasna.")

        start = time.time()
        self.assertEqual((8, 0), najboljsa_cetrt(100, zemljevid))
        self.assertLess(time.time() - start, 3, "Funkcija je prepočasna.")


class Test10(NoWarningTest):
    def test_01_dosegljive(self):
        zemljevid = preberi_zemljevid("dravlje.txt")
        self.assertEqual({(9, 5), (10, 7), (7, 4)}, dosegljive(11, 5, 3, 2, zemljevid))
        self.assertEqual({(9, 5), (10, 7)}, dosegljive(11, 5, 3, 1, zemljevid))
        self.assertEqual(set(), dosegljive(5, 7, 1, 3, zemljevid))

        self.assertEqual({(10, 7), (9, 5), (7, 4), (5, 2), (2, 1), (1, 2)}, dosegljive(11, 5, 4, 4, zemljevid))
        self.assertEqual({(10, 7), (9, 5), (7, 4), (5, 2), (2, 1), (1, 4),
                          (1, 5), (2, 5), (0, 1), (1, 0), (1, 2)}, dosegljive(11, 5, 4, 5, zemljevid))

        self.assertEqual({(2, 7), (1, 5), (3, 7), (2, 5)}, dosegljive(4, 7, 3, 2, zemljevid))
        self.assertEqual({(2, 7), (1, 5), (3, 7), (2, 5), (1, 2), (1, 4)}, dosegljive(4, 7, 3, 3, zemljevid))

    def test_02_dosegljive(self):
        zemljevid = preberi_zemljevid("dravlje-z-izpostavami.txt")
        self.assertEqual({(7, 4), (11, 0), (10, 7), (8, 0), (9, 5)}, dosegljive(11, 5, 3, 2, zemljevid))
        self.assertEqual({(0, 1), (1, 0), (1, 2), (1, 4), (1, 5), (2, 1), (2, 5), (2, 7), (3, 7), (5, 2), (7, 4),
                          (8, 0), (9, 5), (10, 7), (11, 0)},
                         dosegljive(11, 5, 4, 2, zemljevid))

        self.assertEqual({(0, 1), (1, 2), (2, 1), (2, 7), (1, 5), (3, 7), (1, 0), (2, 5), (5, 2), (1, 4)},
                         dosegljive(5, 7, 3, 2, zemljevid))
        self.assertEqual({(0, 1), (1, 2), (2, 1), (2, 7), (1, 5), (3, 7), (1, 0), (2, 5), (1, 4)},
                         dosegljive(5, 7, 2, 2, zemljevid))
        self.assertEqual({(1, 2), (2, 7), (1, 5), (3, 7), (2, 5), (1, 4)},
                         dosegljive(5, 7, 2, 1, zemljevid))
        self.assertEqual({(3, 7)},
                         dosegljive(3, 6, 1, 1, zemljevid))
        self.assertEqual({(3, 7), (2, 5), (2, 7), (1, 5)},
                         dosegljive(3, 6, 1, 2, zemljevid))


if __name__ == "__main__":
    unittest.main()