import java.util.Map;

public class UnarniMinus extends Izraz {
    private Izraz e;

    public UnarniMinus(Izraz e) {
        super();
        this.e = e;
    }

    @Override
    public Double eval(Map<String, Double> env) {
        return -e.eval(env);
    }

    @Override
    public String toString() {
        return "(- " + e + ")";
    }
    
    @Override
    public String izpis() {
        String s = e.izpis();
        return " -" + (mocneje(this, e) ? "("+s+")" : s);
    }
    
    @Override
    public Izraz poenostavi() {
        Izraz s = e.poenostavi();
        if (s.getClass() == getClass()) {
            // poenostavi -(-e) v e
            return ((UnarniMinus)s).e;
        } else {
            return new UnarniMinus(s);
        }
    }
}
