import java.util.Map;

public class Potenca extends Izraz {
	private Izraz e1;
	private Izraz e2;

	public Potenca(Izraz e1, Izraz e2) {
		super();
		this.e1 = e1;
		this.e2 = e2;
	}

	@Override
	public Double eval(Map<String, Double> env) {
		return Math.pow(e1.eval(env), e2.eval(env));
	}

	@Override
	public String toString() {
		return "(^ " + e1 + " " + e2 + ")";
	}
	
	@Override
	public String izpis() {
		String s1 = e1.izpis();
		String s2 = e2.izpis();
		return (!mocneje(e1, this) ? "("+s1+")" : s1) + " ^ " + (mocneje(this, e2) ? "("+s2+")" : s2);
	}
	
	@Override
	public Izraz poenostavi() {
		Izraz s1 = e1.poenostavi();
		Izraz s2 = e2.poenostavi();
		if (s1 instanceof Konstanta && s2 instanceof Konstanta) {
			return new Konstanta(Math.pow(s1.eval(null), s2.eval(null)));
		} else if (s2 instanceof Konstanta && s2.eval(null) == 0) { // e ^ 0
			return new Konstanta(1.0);
		} else if (s1 instanceof Konstanta && s1.eval(null) == 0) { // 0 ^ e
			return new Konstanta(0.0);
		} else if (s1 instanceof Konstanta && s1.eval(null) == 1) { // 1 ^ e
			return new Konstanta(1.0);
		} else if (s2 instanceof Konstanta && s2.eval(null) == 1) { // e ^ 1
			return s1;
		} else {
			return new Potenca(s1, s2);
		}
	}
}
