import java.util.Map;

public class Funkcija extends Izraz {
	private String ime;
	private Izraz e;

	public Funkcija(String ime, Izraz e) {
		super();
		this.ime = ime;
		this.e = e;
	}

	@Override
	public Double eval(Map<String, Double> env) {
		return funkcije.get(ime).apply(e.eval(env));
	}

	@Override
	public String toString() {
		return "(" + ime + " " + e + ")";
	}
	
	@Override
	public String izpis() {
		String s = e.izpis();
		return ime + " " + (mocneje(this, e) ? "("+s+")" : s);
	}
	
	@Override
	public Izraz poenostavi() {
		Izraz s = e.poenostavi();
		if (s instanceof Konstanta) {
			return new Konstanta(funkcije.get(ime).apply(s.eval(null)));
		} else {
			return new Funkcija(ime, s);
		}
	}
}
