import java.util.Map;
import java.util.function.Function;

public abstract class Izraz {
	public abstract Double eval(Map<String, Double> env);

	public abstract String toString();
	
	public String izpis() {
		return toString();
	}
	
	public Izraz poenostavi() {
		return this; // privzeto vrnemo isti izraz
	}

	public static boolean mocneje(Izraz e1, Izraz e2) {
		return prioritete.get(e1.getClass()) < prioritete.get(e2.getClass());
	}
	
	public static final Map<String, Function<Double, Double>> funkcije = Map.of(
            "sin", Math::sin,
            "cos", Math::cos,
            "tan", Math::tan,
            "acos", Math::acos,
            "asin", Math::asin,
            "atan", Math::atan,
            "sqrt", Math::sqrt
    );
	
	private static Map<Class<? extends Izraz>, Integer> prioritete = Map.of(
			Konstanta.class, 0,
			Spremenljivka.class, 0,
			Funkcija.class, 1,
			Potenca.class, 2,
			UnarniMinus.class, 3,
			Krat.class, 4,
			Plus.class, 5,
			Minus.class, 5
	);
}
