import time
import opcua

try:
	server = opcua.Server()
	server.set_endpoint("opc.tcp://localhost:4850/")

	idx = server.register_namespace("http://example.com/")
	obj = server.get_objects_node().add_object(idx,"MyObject")
	var = obj.add_variable(idx, "MyVariable", 0.0)
	var.set_writable()
	
	server.start()
	count = 0
	print("Server started ...")
	while True:
		time.sleep(1)
		count += 0.1
		var.set_value(count)

finally:
	server.stop()
	print("... server stopped.")
