import random
import opcua
from opcua import ua

try:
    client = opcua.Client("opc.tcp://localhost:4840/")
    client.set_user("opcua")
    client.set_password("opcua")
    client.connect()

    # Client has a few methods to get proxy to UA nodes that should always be in address space such as Root or Objects
    root = client.get_root_node()
    objects = client.get_objects_node()
    print("Root node: ", root)
    print("Objects node: ", objects)

    # Node objects have methods to read and write node attributes as well as browse or populate address space
    print("\nChildren of objects: ", objects.get_children())

    # Tags
    print("\nTags: ", root.get_child(["0:Objects", "4:PLC1", "4:MAIN"]).get_children())

    # Get a specific node
    #  - from node id
    var = client.get_node("ns=4;s=MAIN.izdelekID")
    #  - from browse path
    var = root.get_child(["0:Objects", "4:PLC1", "4:MAIN", "4:izdelekID"])
    #  - from stacked access (caution: indices will change!)
    var = root.get_children()[1].get_children()[2].get_children()[11].get_children()[1]        

    # read variable
    print("\nVariable: ", var)
    val = var.get_data_value()
    print("Variable data all: ", val)
    print("Variable value: ", val.Value.Value)
    print("Variable value alt.: ", var.get_value())
    print("Variable status code: ", val.StatusCode.name)

    # write variable
    newVal = 100 + random.randint(1,20)
    print("\nSet value: ", newVal)
    # val.Value.VariantType -> ua.VariantType.Int16
    var.set_value(ua.DataValue(ua.Variant(newVal, val.Value.VariantType)))
    
    # read current value to a new variable    
    var2 = client.get_node("ns=4;s=MAIN.izdelekID")
    print("\nVariable value: ", var2.get_value())

finally:
    client.disconnect()
