# OPC UA subscription demo

import time
import opcua

# event handler
class subscription_handler:
    def datachange_notification(self, node, value, data):
        print(f"[subscription handler] node = {node}, var = {value}, data = {data}")

# main program
try:
	client = opcua.Client("opc.tcp://localhost:4840/")
	client.set_user("opcua")
	client.set_password("opcua")
	client.connect()
			
	#node with variable
	var = client.get_node("ns=4;s=MAIN.izdelekID")

	# subscription
	subscription = client.create_subscription(1000, subscription_handler())
	handle = subscription.subscribe_data_change(var)

	print("Waiting for data change ...")
	
	time.sleep(2)
    
	print("... finished.")
	
	subscription.unsubscribe(handle)
	subscription.delete()	
    
finally:
	client.disconnect()
