/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.vm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import sic.common.Logger;
import sic.sim.vm.Device;

public class FileDevice
extends Device {
    private String filename;
    private RandomAccessFile file;

    private void openFile() {
        try {
            this.file = new RandomAccessFile(this.filename, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.fmterr("Cannot open file '%s'", this.filename);
        }
    }

    @Override
    public int read() {
        if (this.file == null) {
            this.openFile();
        }
        if (this.file == null) {
            return super.read();
        }
        try {
            return this.file.read();
        }
        catch (IOException iOException) {
            Logger.fmterr("Cannot read from file '%s'", this.filename);
            return super.read();
        }
    }

    @Override
    public void write(int n) {
        if (this.file == null) {
            this.openFile();
        }
        if (this.file == null) {
            return;
        }
        try {
            this.file.write(n);
        }
        catch (IOException iOException) {
            Logger.fmterr("Cannot write to file '%s'", this.filename);
        }
    }

    @Override
    public void reset() {
        if (this.file == null) {
            return;
        }
        try {
            this.file.close();
            this.file = null;
        }
        catch (IOException iOException) {
            Logger.fmterr("Cannot reset file '%s'", this.filename);
        }
    }

    public FileDevice(String string) {
        this.filename = string;
    }
}

