/*
 * Decompiled with CFR 0.152.
 */
package sic.sim;

import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import sic.sim.Args;
import sic.sim.breakpoints.Breakpoints;
import sic.sim.breakpoints.DataBreakpointException;
import sic.sim.breakpoints.DataBreakpoints;
import sic.sim.vm.Machine;

public class Executor {
    public static final int MaxSpeed = 100000000;
    public final Machine machine;
    private Timer timer;
    private int timerPeriod;
    private int timerRepeat;
    public final Breakpoints breakpoints;
    private final DataBreakpoints dataBreakpoints;
    public ActionListener onBreakpoint;
    private boolean hasChanged;
    private boolean printStats = false;

    public Executor(Machine machine) {
        this.machine = machine;
        this.breakpoints = new Breakpoints();
        this.dataBreakpoints = machine.memory.dataBreakpoints;
        this.dataBreakpoints.enable();
        this.setSpeed(100);
    }

    public Executor(Machine machine, Args args) {
        this(machine);
        this.printStats = args.isStats();
        if (args.getFreq() > 0) {
            this.setSpeed(args.getFreq());
        }
    }

    public Machine getMachine() {
        return this.machine;
    }

    public int getSpeed() {
        return 1000 / this.timerPeriod * this.timerRepeat;
    }

    public void setSpeed(int n) {
        if (n > 100000000) {
            n = 100000000;
        }
        this.timerRepeat = (n + 99) / 100;
        this.timerPeriod = 1000 * this.timerRepeat / n;
    }

    private void timerTickUntil(Predicate<Machine> predicate) {
        for (int i = 0; i < this.timerRepeat; ++i) {
            int n;
            block5: {
                n = this.machine.registers.getPC();
                try {
                    this.machine.execute();
                    if (this.dataBreakpoints.isEnabled()) break block5;
                    this.dataBreakpoints.enable();
                }
                catch (DataBreakpointException dataBreakpointException) {
                    this.machine.registers.setPC(n);
                    this.hasChanged = true;
                    this.stop();
                    if (this.onBreakpoint == null) break;
                    this.onBreakpoint.actionPerformed(null);
                    break;
                }
            }
            this.hasChanged = true;
            if (n == this.machine.registers.getPC()) {
                this.stop();
                if (!this.printStats) break;
                System.out.printf("Instructions executed: %d\n", this.machine.getInstructionCount());
                break;
            }
            if (this.breakpoints.has(this.machine.registers.getPC())) {
                this.stop();
                if (this.onBreakpoint == null) break;
                this.onBreakpoint.actionPerformed(null);
                break;
            }
            if (!predicate.test(this.machine)) continue;
            this.stop();
            break;
        }
    }

    private void runUntil(final Predicate<Machine> predicate) {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Executor.this.timerTickUntil(predicate);
            }
        }, 0L, (long)this.timerPeriod);
    }

    public void start() {
        Predicate<Machine> predicate = machine -> false;
        this.runUntil(predicate);
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    public void step() {
        if (!this.isRunning()) {
            boolean bl = this.dataBreakpoints.isEnabled();
            this.dataBreakpoints.disable();
            try {
                this.machine.execute();
            }
            catch (DataBreakpointException dataBreakpointException) {
                // empty catch block
            }
            if (bl) {
                this.dataBreakpoints.enable();
            }
            this.hasChanged = true;
        }
    }

    public boolean isRunning() {
        return this.timer != null;
    }

    public boolean hasChanged() {
        boolean bl = this.hasChanged;
        this.hasChanged = false;
        return bl;
    }

    public void runToAddress(int n) {
        this.runUntil(machine -> machine.registers.getPC() == n);
    }

    public void stepOut() {
        Integer n = this.machine.getAddressBelowLastJSUB();
        if (n == null) {
            return;
        }
        this.runUntil(machine -> machine.registers.getPC() == n.intValue());
    }
}

