/*
 * Decompiled with CFR 0.152.
 */
package sic.loader;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import sic.asm.Assembler;
import sic.asm.ErrorCatcher;
import sic.ast.Program;
import sic.common.Logger;
import sic.common.Utils;
import sic.sim.vm.Machine;
import sic.sim.vm.Memory;

public class Loader {
    public static void skipWhitespace(Reader reader) throws IOException {
    }

    public static String readString(Reader reader, int n) throws IOException {
        Loader.skipWhitespace(reader);
        StringBuilder stringBuilder = new StringBuilder();
        while (n-- > 0) {
            stringBuilder.append((char)reader.read());
        }
        return stringBuilder.toString();
    }

    public static int readByte(Reader reader) throws IOException {
        Loader.skipWhitespace(reader);
        return Integer.parseInt(Loader.readString(reader, 2), 16);
    }

    public static int readWord(Reader reader) throws IOException {
        Loader.skipWhitespace(reader);
        return Integer.parseInt(Loader.readString(reader, 6), 16);
    }

    public static void loadRawCode(Machine machine, int n, byte[] byArray) {
        System.arraycopy(byArray, 0, machine.memory.memory, n, byArray.length);
        machine.registers.setPC(n);
    }

    public static boolean loadSection(Machine machine, Reader reader) {
        try {
            if (reader.read() != 72) {
                return false;
            }
            Loader.readString(reader, 6);
            int n = Loader.readWord(reader);
            int n2 = Loader.readWord(reader);
            if (reader.read() == 13) {
                reader.read();
            }
            Memory memory = machine.memory;
            int n3 = reader.read();
            while (n3 == 84) {
                int n4 = Loader.readWord(reader);
                int n5 = Loader.readByte(reader);
                while (n5-- > 0) {
                    if (n4 < n || n4 >= n + n2) {
                        return false;
                    }
                    byte by = (byte)Loader.readByte(reader);
                    memory.setByteRaw(n4++, by);
                }
                if (reader.read() == 13) {
                    reader.read();
                }
                n3 = reader.read();
            }
            while (n3 == 77) {
                Loader.readWord(reader);
                Loader.readByte(reader);
                if (reader.read() == 13) {
                    reader.read();
                }
                n3 = reader.read();
            }
            if (n3 != 69) {
                return false;
            }
            machine.registers.setPC(Loader.readWord(reader));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean loadObj(Machine machine, String string) {
        try {
            FileReader fileReader = new FileReader(string);
            Loader.loadSection(machine, fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.fmterr("Error reading file '%s'.", string);
            return false;
        }
        return true;
    }

    public static void loadAsm(Machine machine, String string) {
        Assembler assembler = new Assembler();
        ErrorCatcher errorCatcher = assembler.errorCatcher;
        Program program = assembler.assemble(Utils.readFile(string));
        if (errorCatcher.count() > 0) {
            errorCatcher.print();
            return;
        }
        StringWriter stringWriter = new StringWriter();
        assembler.generateObj(program, stringWriter, false);
        StringReader stringReader = new StringReader(((Object)stringWriter).toString());
        Loader.loadSection(machine, stringReader);
    }
}

