/*
 * Decompiled with CFR 0.152.
 */
package sic.link.visitors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sic.link.LinkerError;
import sic.link.section.ExtDef;
import sic.link.section.Section;
import sic.link.section.TRecord;
import sic.link.visitors.SectionVisitor;

public class FirstPassVisitor
extends SectionVisitor {
    private static final String PHASE = "first pass";
    public Map<String, Section> csTable;
    public Map<String, ExtDef> esTable;
    private long csAddr;

    public FirstPassVisitor(Map<String, ExtDef> map) {
        this.esTable = map;
        this.csTable = new HashMap<String, Section>();
        this.csAddr = 0L;
    }

    @Override
    public void visit(Section section) throws LinkerError {
        String string = section.getName();
        section.setStart(this.csAddr);
        if (this.csTable.get(string) != null) {
            throw new LinkerError(PHASE, "Duplicated section name: " + string + " at " + section.getLocation() + " and " + this.csTable.get(string).getLocation());
        }
        this.csTable.put(string, section);
        this.esTable.put(string, new ExtDef(string, 0L, section.getStart()));
        if (section.getExtDefs() != null) {
            for (ExtDef object : section.getExtDefs()) {
                object.accept(this);
            }
        }
        if (section.getTRecords() != null) {
            Collections.sort(section.getTRecords(), (tRecord, tRecord2) -> {
                if (tRecord.getStartAddr() < tRecord2.getStartAddr()) {
                    return -1;
                }
                if (tRecord.getStartAddr() > tRecord2.getStartAddr()) {
                    return 1;
                }
                return 0;
            });
            for (TRecord tRecord3 : section.getTRecords()) {
                tRecord3.accept(this);
            }
        }
        this.csAddr += section.getLength();
    }

    @Override
    public void visit(ExtDef extDef) throws LinkerError {
        String string = extDef.getName();
        extDef.setCsAddress(this.csAddr);
        if (this.esTable.get(string) != null) {
            throw new LinkerError(PHASE, "Duplicated external symbol definition '" + string + "'", extDef.getLocation());
        }
        this.esTable.put(string, extDef);
    }

    @Override
    public void visit(TRecord tRecord) {
        long l = tRecord.getStartAddr();
        tRecord.setStartAddr(l + this.csAddr);
    }
}

