/*
 * Decompiled with CFR 0.152.
 */
package sic.link.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sic.link.LinkerError;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.Section;
import sic.link.section.Sections;
import sic.link.ui.LinkerGui;
import sic.link.ui.SectionEditListener;

public class EditSectionGui {
    private Sections sections;
    private Section selectedSection = null;
    private List<String> refs;
    private List<String> defs;
    private String selectedSymbol = null;
    private boolean selectedDef = false;
    private JPanel leftPanel;
    private JPanel rightPanel;
    DefaultListModel<String> sectionModel;
    DefaultListModel<String> refsModel;
    DefaultListModel<String> defsModel;
    JList<String> sectionList;
    JList<String> defsList;
    JList<String> refsList;
    private JPanel editSectionPanel;
    private JPanel editSymbolPanel;
    JLabel sectionTitle;
    JButton upButton;
    JButton downButton;
    JTextField secName;
    JButton secDelete;
    JButton secApply;
    JLabel symbolTitle;
    JTextField symName;
    JButton symDelete;
    JButton symApply;
    JButton proceed;
    JButton help;

    public EditSectionGui(Sections sections) {
        this.sections = sections;
    }

    public void sectionEdit(final SectionEditListener sectionEditListener) {
        final JFrame jFrame = new JFrame("Section editor");
        jFrame.setDefaultCloseOperation(2);
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.sectionModel = new DefaultListModel();
        this.refsModel = new DefaultListModel();
        this.defsModel = new DefaultListModel();
        this.editSectionPanel = new JPanel();
        this.editSymbolPanel = new JPanel();
        this.sectionTitle = new JLabel("Selected section : sec name");
        this.sectionTitle.setAlignmentX(0.0f);
        this.upButton = new JButton("Up");
        this.downButton = new JButton("Down");
        this.secName = new JTextField("Name", 8);
        this.secDelete = new JButton("Remove");
        this.secApply = new JButton("Rename");
        this.symbolTitle = new JLabel("selected Symbol : sym name");
        this.symbolTitle.setAlignmentX(0.0f);
        this.symName = new JTextField("Name", 8);
        this.symDelete = new JButton("Remove");
        this.symApply = new JButton("Rename");
        this.sectionList = new JList<String>(this.sectionModel);
        this.refsList = new JList<String>(this.refsModel);
        this.defsList = new JList<String>(this.defsModel);
        this.proceed = new JButton("Done");
        this.help = new JButton("Help");
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.leftPanel.add(new JLabel("Sections"));
        this.leftPanel.add(new JScrollPane(this.sectionList));
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        this.rightPanel.add(new JLabel("Definitions"));
        this.rightPanel.add(new JScrollPane(this.defsList));
        this.rightPanel.add(new JLabel("References"));
        this.rightPanel.add(new JScrollPane(this.refsList));
        this.editSectionPanel.setLayout(new GridLayout(4, 1));
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.add(this.sectionTitle);
        this.editSectionPanel.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.upButton);
        jPanel2.add(this.downButton);
        this.editSectionPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Name:"));
        jPanel3.add(this.secName);
        this.editSectionPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.secApply);
        jPanel4.add(this.secDelete);
        this.editSectionPanel.add(jPanel4);
        this.editSectionPanel.setVisible(false);
        this.editSymbolPanel.setLayout(new GridLayout(3, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setAlignmentX(0.0f);
        jPanel5.add(this.symbolTitle);
        this.editSymbolPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(new JLabel("Name"));
        jPanel6.add(this.symName);
        this.editSymbolPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.symApply);
        jPanel7.add(this.symDelete);
        this.editSymbolPanel.add(jPanel7);
        this.editSymbolPanel.setVisible(false);
        this.fillSections();
        this.sectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EditSectionGui.this.sectionList.getSelectedIndex() != -1) {
                    EditSectionGui.this.selectedSection = EditSectionGui.this.sections.getSections().get(EditSectionGui.this.sectionList.getSelectedIndex());
                    EditSectionGui.this.editSectionPanel.setVisible(true);
                    EditSectionGui.this.editSymbolPanel.setVisible(false);
                    EditSectionGui.this.sectionTitle.setText("Selected section: " + EditSectionGui.this.selectedSection.getName());
                    EditSectionGui.this.secName.setText(EditSectionGui.this.selectedSection.getName());
                    EditSectionGui.this.fillSymbols();
                }
            }
        });
        this.refsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EditSectionGui.this.refsList.getSelectedIndex() != -1) {
                    EditSectionGui.this.selectedSymbol = EditSectionGui.this.refs.get(EditSectionGui.this.refsList.getSelectedIndex());
                    EditSectionGui.this.selectedDef = false;
                    EditSectionGui.this.editSymbolPanel.setVisible(true);
                    EditSectionGui.this.editSectionPanel.setVisible(false);
                    EditSectionGui.this.symbolTitle.setText("Selected reference: " + EditSectionGui.this.selectedSymbol);
                    EditSectionGui.this.symName.setText(EditSectionGui.this.selectedSymbol);
                }
            }
        });
        this.defsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EditSectionGui.this.defsList.getSelectedIndex() != -1) {
                    EditSectionGui.this.selectedSymbol = EditSectionGui.this.defs.get(EditSectionGui.this.defsList.getSelectedIndex());
                    EditSectionGui.this.selectedDef = true;
                    EditSectionGui.this.editSymbolPanel.setVisible(true);
                    EditSectionGui.this.editSectionPanel.setVisible(false);
                    EditSectionGui.this.symbolTitle.setText("Selected definition: " + EditSectionGui.this.selectedSymbol);
                    EditSectionGui.this.symName.setText(EditSectionGui.this.selectedSymbol);
                }
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = EditSectionGui.this.sectionList.getSelectedIndex();
                if (n > 0 && EditSectionGui.this.selectedSection != null) {
                    try {
                        EditSectionGui.this.sections.move(EditSectionGui.this.selectedSection.getName(), n - 1);
                        EditSectionGui.this.fillSections();
                        EditSectionGui.this.sectionList.setSelectedIndex(n - 1);
                    }
                    catch (LinkerError linkerError) {
                        LinkerGui.showError(linkerError.getMessage());
                    }
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = EditSectionGui.this.sectionList.getSelectedIndex();
                if (n >= 0 && n < EditSectionGui.this.sections.getSections().size() - 1 && EditSectionGui.this.selectedSection != null) {
                    try {
                        EditSectionGui.this.sections.move(EditSectionGui.this.selectedSection.getName(), EditSectionGui.this.sectionList.getSelectedIndex() + 1);
                        EditSectionGui.this.fillSections();
                        EditSectionGui.this.sectionList.setSelectedIndex(n + 1);
                    }
                    catch (LinkerError linkerError) {
                        LinkerGui.showError(linkerError.getMessage());
                    }
                }
            }
        });
        this.secApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditSectionGui.this.secName.getText().length() > 6) {
                    LinkerGui.showError("Please enter a name that has 6 or less characters.");
                } else if (!EditSectionGui.this.selectedSection.getName().equals(EditSectionGui.this.secName.getText())) {
                    try {
                        EditSectionGui.this.sections.rename(EditSectionGui.this.selectedSection.getName(), EditSectionGui.this.secName.getText());
                        EditSectionGui.this.fillSections();
                        EditSectionGui.this.sectionTitle.setText("Selected section: " + EditSectionGui.this.selectedSection.getName());
                    }
                    catch (LinkerError linkerError) {
                        LinkerGui.showError(linkerError.getMessage());
                    }
                }
            }
        });
        this.symApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditSectionGui.this.symName.getText().length() > 6) {
                    LinkerGui.showError("Please enter a name that has 6 or less characters.");
                } else if (!EditSectionGui.this.selectedSymbol.equals(EditSectionGui.this.symName.getText())) {
                    try {
                        if (EditSectionGui.this.selectedDef) {
                            EditSectionGui.this.sections.renameDef(EditSectionGui.this.selectedSection.getName(), EditSectionGui.this.selectedSymbol, EditSectionGui.this.symName.getText());
                        } else {
                            EditSectionGui.this.sections.renameRef(EditSectionGui.this.selectedSection.getName(), EditSectionGui.this.selectedSymbol, EditSectionGui.this.symName.getText());
                        }
                        EditSectionGui.this.fillSymbols();
                        EditSectionGui.this.selectedSymbol = EditSectionGui.this.symName.getText();
                        if (EditSectionGui.this.selectedDef) {
                            EditSectionGui.this.symbolTitle.setText("Selected definition: " + EditSectionGui.this.selectedSymbol);
                        } else {
                            EditSectionGui.this.symbolTitle.setText("Selected reference: " + EditSectionGui.this.selectedSymbol);
                        }
                    }
                    catch (LinkerError linkerError) {
                        LinkerGui.showError(linkerError.getMessage());
                    }
                }
            }
        });
        this.secDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Would you like to remove section " + EditSectionGui.this.selectedSection.getName() + " from linking?", "Confirmation", 0);
                if (n == 0) {
                    try {
                        EditSectionGui.this.sections.remove(EditSectionGui.this.selectedSection.getName());
                        EditSectionGui.this.fillSections();
                        EditSectionGui.this.editSectionPanel.setVisible(false);
                    }
                    catch (LinkerError linkerError) {
                        LinkerGui.showError(linkerError.getMessage());
                    }
                }
            }
        });
        this.symDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Would you like to remove symbol " + EditSectionGui.this.selectedSymbol + " from section " + EditSectionGui.this.selectedSection.getName() + "?", "Confirmation", 0);
                if (n == 0) {
                    try {
                        if (EditSectionGui.this.selectedDef) {
                            EditSectionGui.this.sections.removeDef(EditSectionGui.this.selectedSection.getName(), EditSectionGui.this.selectedSymbol);
                        } else {
                            EditSectionGui.this.sections.removeRef(EditSectionGui.this.selectedSection.getName(), EditSectionGui.this.selectedSymbol);
                        }
                        EditSectionGui.this.fillSymbols();
                        EditSectionGui.this.editSymbolPanel.setVisible(false);
                    }
                    catch (LinkerError linkerError) {
                        LinkerGui.showError(linkerError.getMessage());
                    }
                }
            }
        });
        this.proceed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
                sectionEditListener.onEdited(EditSectionGui.this.sections, "0");
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditSectionGui.showHelp();
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(1, 2));
        jPanel8.add(this.leftPanel);
        jPanel8.add(this.rightPanel);
        JPanel jPanel9 = new JPanel();
        jPanel9.add(this.editSectionPanel);
        jPanel9.add(this.editSymbolPanel);
        JPanel jPanel10 = new JPanel();
        jPanel10.add(this.proceed);
        jPanel10.add(this.help);
        jFrame.add((Component)new JPanel(), "North");
        jFrame.add((Component)jPanel8, "Center");
        jFrame.add((Component)new JPanel(), "West");
        jFrame.add((Component)jPanel9, "East");
        jFrame.add((Component)jPanel10, "South");
        jFrame.setSize(600, 400);
        jFrame.setVisible(true);
    }

    private void fillSections() {
        this.sectionModel.clear();
        int n = 0;
        for (Section section : this.sections.getSections()) {
            this.sectionModel.addElement(n + " - " + section.getName());
            ++n;
        }
    }

    private void fillSymbols() {
        this.refsModel.clear();
        this.defsModel.clear();
        this.refs = new ArrayList<String>();
        this.defs = new ArrayList<String>();
        for (ExtDef object : this.selectedSection.getExtDefs()) {
            this.defs.add(object.getName());
            this.defsModel.addElement(object.getName());
        }
        for (ExtRef extRef : this.selectedSection.getExtRefs()) {
            this.refs.add(extRef.getName());
            this.refsModel.addElement(extRef.getName());
        }
    }

    public static void showHelp() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Section Editor for SIC/XE Linker").append(string).append(string).append("Rename, move or remove the sections and symbols before linking.").append(string).append(string).append("List on the left contains all the sections that were parsed from input files.").append(string).append("Lists on the right contain external definitions and references for selected section.").append(string).append("Panel on the right has the controls for changing the selected section or external symbol.").append(string).append(string).append("Editing a section:").append(string).append("- Select the section that you want to edit.").append(string).append("- Rename the section using the Name text field and then click the Rename button.").append(string).append("- Change the section's position on the list by moving it with the Up/Down buttons on the right.").append(string).append("- Remove the section from linking by clicking the Remove button.").append(string).append(string).append("Editing a symbol:").append(string).append(" - Select the section that contains the symbol.").append(string).append(" - Select the symbol from the References or Definitions panels.").append(string).append(" - Rename the symbol using the Name text field and then click the Rename button.").append(string).append(" - Remove the symbol from section by clicking the Remove button.").append(string).append(string).append("When you want to finish editing and proceed with linking, click the Done button").append(string);
        JOptionPane jOptionPane = new JOptionPane(stringBuilder.toString(), -1);
        JDialog jDialog = jOptionPane.createDialog("SIC Linker Help");
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
    }
}

