/*
 * Decompiled with CFR 0.152.
 */
package sic.disasm;

import sic.asm.Location;
import sic.ast.Command;
import sic.ast.data.DataHex;
import sic.ast.instructions.Instruction;
import sic.ast.instructions.InstructionF1;
import sic.ast.instructions.InstructionF2n;
import sic.ast.instructions.InstructionF2r;
import sic.ast.instructions.InstructionF2rn;
import sic.ast.instructions.InstructionF2rr;
import sic.ast.instructions.InstructionF3;
import sic.ast.instructions.InstructionF3m;
import sic.ast.instructions.InstructionF4m;
import sic.ast.storage.StorageData;
import sic.common.Flags;
import sic.common.Mnemonic;
import sic.common.Mnemonics;
import sic.common.Opcode;
import sic.sim.vm.Machine;

public class Disassembler {
    private final Mnemonics mnemonics;
    private final Machine machine;
    private int location;
    private int fetchAddr;

    public Disassembler(Mnemonics mnemonics, Machine machine) {
        this.mnemonics = mnemonics;
        this.machine = machine;
    }

    public int location() {
        return this.location;
    }

    public void setLocation(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 1048575) {
            n = 1048575;
        }
        this.location = n;
    }

    public void gotoPC() {
        this.setLocation(this.machine.registers.getPC());
    }

    public void next() {
        Instruction instruction = this.disassemble(this.location);
        this.setLocation(this.location + (instruction == null ? 1 : instruction.size()));
    }

    public void prev() {
        Instruction instruction;
        int n = this.location;
        while ((instruction = this.disassemble(--n)) == null || n + instruction.size() > this.location) {
        }
        this.setLocation(n);
    }

    public void next(int n) {
        while (n-- > 0) {
            this.next();
        }
    }

    public void prev(int n) {
        while (n-- > 0) {
            this.prev();
        }
    }

    protected int fetch() {
        if (this.fetchAddr < 0) {
            return 0;
        }
        if (this.fetchAddr > 1048575) {
            return 0;
        }
        return this.machine.memory.getByteRaw(this.fetchAddr++);
    }

    public Instruction disassemble(int n) {
        this.fetchAddr = n;
        int n2 = this.fetch();
        String string = Opcode.getName(n2 & 0xFC);
        if (string == null) {
            return null;
        }
        Mnemonic mnemonic = this.mnemonics.get(string);
        Location location = new Location(-1, -1, -1);
        switch (mnemonic.format) {
            case F1: {
                return new InstructionF1(location, "", mnemonic);
            }
            case F2n: {
                return new InstructionF2n(location, "", mnemonic, this.fetch() >> 4);
            }
            case F2r: {
                return new InstructionF2r(location, "", mnemonic, this.fetch() >> 4);
            }
            case F2rn: {
                int n3 = this.fetch();
                return new InstructionF2rn(location, "", mnemonic, (n3 & 0xF0) >> 4, (n3 & 0xF) + 1);
            }
            case F2rr: {
                int n4 = this.fetch();
                return new InstructionF2rr(location, "", mnemonic, (n4 & 0xF0) >> 4, n4 & 0xF);
            }
            case F3: {
                this.fetch();
                this.fetch();
                return new InstructionF3(location, "", mnemonic);
            }
            case F3m: 
            case F4m: {
                int n5;
                int n6 = this.fetch();
                int n7 = this.fetch();
                Flags flags = new Flags(n2, n6);
                if (flags.isExtended()) {
                    int n8 = flags.operandF4(n6, n7, this.fetch());
                    mnemonic = this.mnemonics.get("+" + string);
                    return new InstructionF4m(location, "", mnemonic, flags, n8, null);
                }
                int n9 = n5 = flags.isSic() ? flags.operandSic(n6, n7) : flags.operandF3(n6, n7);
                if (flags.isPCRelative()) {
                    n5 = flags.operandPCRelative(n5);
                }
                return new InstructionF3m(location, "", mnemonic, flags, n5, null);
            }
        }
        return null;
    }

    public Command disassembleSafe(int n) {
        Instruction instruction = this.disassemble(n);
        if (instruction == null) {
            DataHex dataHex = new DataHex(this.mnemonics.get((String)"BYTE").opcode);
            dataHex.setData((byte)this.machine.memory.getByteRaw(n));
            return new StorageData(new Location(-1, -1, -1), "", this.mnemonics.get("BYTE"), dataHex);
        }
        return instruction;
    }

    public int getLocationAfter(int n) {
        Instruction instruction = this.disassemble(n);
        return n + (instruction == null ? 1 : instruction.size());
    }

    public int getNextPCLocation() {
        return this.getLocationAfter(this.machine.registers.getPC());
    }
}

