/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.instructions;

import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Program;
import sic.ast.Symbol;
import sic.ast.instructions.InstructionF34Base;
import sic.common.Flags;
import sic.common.Mnemonic;
import sic.common.SICXE;

public class InstructionF3m
extends InstructionF34Base {
    public InstructionF3m(Location location, String string, Mnemonic mnemonic, Flags flags, int n, String string2) {
        super(location, string, mnemonic, flags, n, string2);
    }

    @Override
    public void checkSymbol(Program program, Symbol symbol) throws AsmError {
        if (symbol.isImported()) {
            throw new AsmError(this.loc, "External symbol '%s' is not allowed here", symbol);
        }
    }

    @Override
    public boolean resolveAddressing(Program program) throws AsmError {
        if ((this.resolvedSymbol == null || this.resolvedSymbol.isAbsolute()) && (this.flags.isImmediate() ? SICXE.isCdisp(this.resolvedValue) : SICXE.isDisp(this.resolvedValue))) {
            return true;
        }
        if (program.section().isPCRelativeAddressing(this.resolvedValue)) {
            this.flags.setPCRelative();
            this.resolvedValue = SICXE.intToSdisp(program.section().PCDisplacement(this.resolvedValue));
            return true;
        }
        if (program.section().isBaseAddressing(this.resolvedValue)) {
            this.flags.setBaseRelative();
            this.resolvedValue = SICXE.intToDisp(program.section().baseDisplacement(this.resolvedValue));
            return true;
        }
        if (this.flags.isImmediate() ? SICXE.isSdisp(this.resolvedValue) : SICXE.isDisp(this.resolvedValue)) {
            program.section().addRelocation(program.locctr() + 1, 3);
            return true;
        }
        if (this.flags.isSimple() && SICXE.isSicAddr(this.resolvedValue)) {
            this.flags.set_ni(0);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public void emitRawCode(byte[] byArray, int n) {
        byArray[n] = this.flags.combineWithOpcode(this.mnemonic.opcode);
        byArray[n + 1] = this.flags.isSic() ? (byte)(this.flags.get_x() | this.resolvedValue >> 8 & 0x7F) : (byte)(this.flags.get_xbpe() | this.resolvedValue >> 8 & 0xF);
        byArray[n + 2] = (byte)(this.resolvedValue & 0xFF);
    }
}

