/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.expression;

import java.util.LinkedHashSet;
import java.util.Set;
import sic.asm.AsmError;
import sic.asm.Location;
import sic.asm.parsing.ExpressionParser;
import sic.ast.Program;
import sic.ast.Symbols;
import sic.ast.expression.Expr;

public class ExprSym
extends Expr {
    public final String value;

    public ExprSym(Location location, String string) {
        super("<sym>", location, 0);
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Expr parse(ExpressionParser expressionParser) throws AsmError {
        return this;
    }

    @Override
    public Set<String> extractSyms() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(this.value);
        return linkedHashSet;
    }

    @Override
    public boolean hasSyms() {
        return true;
    }

    @Override
    public int countAddSub() {
        return 1;
    }

    @Override
    public boolean canEval(Program program) {
        return program.section().symbols.isEvaluated(this.value);
    }

    @Override
    public int eval(Program program) throws AsmError {
        Symbols symbols = program.section().symbols;
        if (symbols.isEvaluated(this.value)) {
            return symbols.get(this.value).value();
        }
        throw new AsmError(this.loc, "Undefined symbol '%s'", this.value);
    }
}

