/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.expression;

import java.util.Set;
import sic.asm.AsmError;
import sic.asm.Location;
import sic.asm.parsing.ExpressionParser;
import sic.ast.Program;
import sic.ast.expression.Expr;
import sic.ast.expression.ExprInt;
import sic.ast.expression.ExprStar;

public class ExprOp
extends Expr {
    private Expr left;
    private Expr right;

    public ExprOp(String string, Location location, int n) {
        super(string, location, n);
    }

    public String toString() {
        return this.left + this.name + this.right;
    }

    public Expr left() {
        return this.left;
    }

    public Expr right() {
        return this.right;
    }

    @Override
    public Expr parse(ExpressionParser expressionParser) throws AsmError {
        if ("*".equals(this.name)) {
            return new ExprStar(this.loc);
        }
        if ("+".equals(this.name)) {
            return expressionParser.parseExpression(this.leftBP);
        }
        if ("-".equals(this.name)) {
            this.left = new ExprInt(this.loc, 0);
            this.right = expressionParser.parseExpression(this.leftBP);
        }
        return this;
    }

    @Override
    public Expr parseLeft(ExpressionParser expressionParser, Expr expr) throws AsmError {
        this.left = expr;
        this.right = expressionParser.parseExpression(this.leftBP);
        return this;
    }

    @Override
    public boolean hasSyms() {
        return this.left.hasSyms() || this.right.hasSyms();
    }

    @Override
    public int countAddSub() {
        if ("+".equals(this.name)) {
            return this.left.countSyms() + this.right.countSyms();
        }
        if ("-".equals(this.name)) {
            return this.left.countSyms() - this.right.countSyms();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Set<String> extractSyms() {
        Set<String> set = this.left.extractSyms();
        Set<String> set2 = this.right.extractSyms();
        if (set == null) {
            return set2;
        }
        if (set2 == null) {
            return set;
        }
        set.addAll(set2);
        return set;
    }

    @Override
    public boolean canEval(Program program) {
        return this.left.canEval(program) && this.right.canEval(program);
    }

    @Override
    public int eval(Program program) throws AsmError {
        if ("+".equals(this.name)) {
            return this.left.eval(program) + this.right.eval(program);
        }
        if ("-".equals(this.name)) {
            return this.left.eval(program) - this.right.eval(program);
        }
        if ("*".equals(this.name)) {
            return this.left.eval(program) * this.right.eval(program);
        }
        if ("/".equals(this.name)) {
            return this.left.eval(program) / this.right.eval(program);
        }
        if ("%".equals(this.name)) {
            return this.left.eval(program) % this.right.eval(program);
        }
        return 0;
    }
}

