/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.data;

import sic.asm.AsmError;
import sic.asm.parsing.Parser;

public abstract class Data {
    public final int opcode;
    protected byte[] data;
    protected Data next;

    public Data(int n) {
        this.opcode = n;
    }

    public String toString() {
        return this.next == null ? "" : "," + this.next.toString();
    }

    public void parse(Parser parser, boolean bl) throws AsmError {
        if (bl && parser.skipIfComma()) {
            this.next = parser.operandParser.parseData(this.opcode, true);
        }
    }

    public boolean equals(Data data) {
        if (this.opcode != data.opcode) {
            return false;
        }
        if (this.data.length != data.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == data.data[i]) continue;
            return false;
        }
        if (this.next == null && data.next == null) {
            return true;
        }
        if (this.next != null && data.next != null) {
            return this.next.equals(data.next);
        }
        return false;
    }

    public void setData(byte by) {
        this.data = new byte[1];
        this.data[0] = by;
    }

    protected int sizeHere() {
        switch (this.opcode) {
            case 3: {
                return this.data.length;
            }
            case 4: {
                return (this.data.length + 2) / 3 * 3;
            }
            case 5: {
                return (this.data.length + 5) / 6 * 6;
            }
        }
        return 0;
    }

    public int size() {
        int n = this.sizeHere();
        if (this.next != null) {
            n += this.next.size();
        }
        return n;
    }

    public void emit(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, this.data.length);
        int n2 = this.sizeHere();
        for (int i = byArray.length; i < n2; ++i) {
            byArray[i] = 0;
        }
        if (this.next != null) {
            this.next.emit(byArray, n + n2);
        }
    }
}

