/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sic.asm.AsmError;
import sic.ast.Block;
import sic.ast.Command;
import sic.ast.Node;
import sic.ast.Section;
import sic.ast.StorageSymbol;
import sic.ast.Symbol;
import sic.ast.instructions.Instruction;

public class Program
extends Node {
    private String name;
    private int start;
    private int first;
    public final List<Command> commands = new ArrayList<Command>();
    public final List<Section> sections = new ArrayList<Section>();
    private Section section;
    private int maxLabelLength;

    public Program() {
        this.switchSection("");
        this.maxLabelLength = 3;
    }

    public String toString() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int start() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
        this.setFirst(n);
    }

    public boolean isRelocatable() {
        return this.start == 0;
    }

    public int first() {
        return this.first;
    }

    public void setFirst(int n) {
        this.first = n;
    }

    public Section section() {
        return this.section;
    }

    public Block block() {
        return this.section.block();
    }

    public int locctr() {
        return this.block().locctr();
    }

    public void step(int n) {
        this.block().step(n);
    }

    public void setLocctr(int n) {
        this.block().setLocctr(n);
    }

    public int maxLabelLength() {
        return this.maxLabelLength;
    }

    public int maxSymbolLength() {
        int n = -1;
        for (Section section : this.sections) {
            int n2 = section.name.length() + section.symbols.maxLength() + 1;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void flushAllLiterals() throws AsmError {
        for (Section section : this.sections) {
            section.literals.flush(this);
        }
    }

    public Section findSection(String string) {
        for (Section section : this.sections) {
            if (!section.name.equals(string)) continue;
            return section;
        }
        return null;
    }

    public void switchSection(String string) {
        this.section = this.findSection(string);
        if (this.section == null) {
            this.section = new Section(string);
            this.sections.add(this.section);
        }
    }

    public void switchDefault() {
        this.switchSection("");
        this.section.switchBlock("");
    }

    public void append(Command command) throws AsmError {
        this.commands.add(command);
        this.block().append(command);
        if (command.label().length() > this.maxLabelLength) {
            this.maxLabelLength = command.label.length();
        }
    }

    @Override
    public void enter(Program program) {
        this.switchDefault();
    }

    public HashMap<Integer, Symbol> getLabels() {
        HashMap<Integer, Symbol> hashMap = new HashMap<Integer, Symbol>();
        for (Section section : this.sections) {
            List<Symbol> list = section.symbols.labels();
            for (Symbol symbol : list) {
                hashMap.put(symbol.value(), symbol);
            }
        }
        return hashMap;
    }

    public HashMap<Integer, StorageSymbol> getDataLabels() {
        HashMap<Integer, StorageSymbol> hashMap = new HashMap<Integer, StorageSymbol>();
        for (Section section : this.sections) {
            List<StorageSymbol> list = section.symbols.dataLabels();
            for (StorageSymbol storageSymbol : list) {
                hashMap.put(storageSymbol.value(), storageSymbol);
            }
        }
        return hashMap;
    }

    public long countInstructions() {
        return this.commands.stream().filter(command -> command instanceof Instruction).count();
    }
}

