/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import java.io.Writer;
import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.WriteVisitor;
import sic.ast.Block;
import sic.ast.Command;
import sic.ast.Program;
import sic.ast.Relocation;
import sic.ast.Section;
import sic.ast.Symbol;
import sic.ast.directives.DirectiveORG;

public class WriteText
extends WriteVisitor {
    public final boolean addSpace;
    public final String space;
    private StringBuilder buf = new StringBuilder();
    private int recordBytes = 0;
    private int textAddr;

    public WriteText(Program program, ErrorCatcher errorCatcher, Writer writer, boolean bl) {
        super(program, errorCatcher, writer);
        this.addSpace = bl;
        this.space = bl ? " " : "";
    }

    private void flushBuf() {
        if (this.recordBytes == 0) {
            return;
        }
        String string = this.buf.toString();
        while (this.recordBytes > 0) {
            int n = string.length() <= 60 ? string.length() / 2 : 30;
            this.w("T%s%06X%s%02X", this.space, this.textAddr, this.space, n);
            this.w(string.substring(0, n * 2));
            string = string.substring(n * 2);
            this.w("\n");
            this.textAddr += n;
            this.recordBytes -= n;
        }
        this.buf = new StringBuilder();
        this.recordBytes = 0;
    }

    public void visit(Program program) {
        this.visitSections(program.sections);
    }

    public void visit(Section section) {
        int n = "".equals(section.name) ? this.program.start() : 0;
        String string = "".equals(section.name) ? this.program.name() : section.name();
        this.w("H%s%-6s%s%06X%s%06X\n", this.space, string, this.space, n, this.space, section.size());
        int n2 = 0;
        for (Symbol object : section.symbols.asSortedList()) {
            if (!object.isExported() || object.name.equals(string)) continue;
            if (n2 == 0) {
                this.w("D");
            }
            this.w("%s%-6s%s%06X", this.space, object.name, this.space, object.value() - n);
            if (++n2 < 6) continue;
            n2 = 0;
            this.w("\n");
        }
        if (n2 > 0) {
            this.w("\n");
        }
        n2 = 0;
        for (Symbol symbol : section.symbols.asSortedList()) {
            if (!symbol.isImported()) continue;
            if (n2 == 0) {
                this.w("R");
            }
            this.w("%s%-6s", this.space, symbol.name);
            if (++n2 < 12) continue;
            n2 = 0;
            this.w("\n");
        }
        if (n2 > 0) {
            this.w("\n");
        }
        this.textAddr = n;
        this.visitBlocks(section.blocks);
        this.flushBuf();
        for (Relocation relocation : section.relocations) {
            this.w(relocation.flag == '\u0000' ? String.format("M%s%06X%s%02X\n", this.space, relocation.address, this.space, relocation.length) : String.format("M%s%06X%s%02X%s%c%s\n", this.space, relocation.address, this.space, relocation.length, this.space, Character.valueOf(relocation.flag), relocation.symbol));
        }
        int n3 = "".equals(section.name) ? this.program.first() : n;
        this.w("E%s%06X\n", this.space, n3);
    }

    public void visit(Block block) throws AsmError {
        this.visitCommands(block.commands);
    }

    public void visit(Command command) throws AsmError {
        if (command.size() > 0) {
            this.buf.append(this.space);
        }
        if (this.recordBytes == 0) {
            this.textAddr = this.program.locctr();
        }
        int n = this.buf.length();
        boolean bl = command.emitText(this.buf);
        this.recordBytes += (this.buf.length() - n) / 2;
        if (bl) {
            this.flushBuf();
        }
    }

    public void visit(DirectiveORG directiveORG) {
        this.flushBuf();
    }
}

