/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import java.io.Writer;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.WriteVisitor;
import sic.ast.Command;
import sic.ast.Comment;
import sic.ast.Program;
import sic.common.Conversion;

public class WriteProgram
extends WriteVisitor {
    public WriteProgram(Program program, ErrorCatcher errorCatcher, Writer writer) {
        super(program, errorCatcher, writer);
    }

    public void visit(Command command) {
        int n = this.program.maxLabelLength();
        int n2 = 6;
        String string = command.nameToString();
        if (string.startsWith("=") || string.startsWith("+")) {
            --n;
            ++n2;
        }
        this.w(Conversion.addrToHex(this.program.locctr()) + "  ");
        this.w(Conversion.bytesToHexNice(command.emitRawCode(), 4));
        this.w(String.format("  %-" + n + "s  ", command.label()));
        this.w(String.format("%-" + n2 + "s  ", string));
        this.w(command.operandToString());
        this.w("    " + command.comment());
        this.w("\n");
    }

    public void visit(Comment comment) {
        this.w("                  " + comment.comment() + "\n");
    }
}

