/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.Visitor;
import sic.ast.Command;
import sic.ast.Program;
import sic.ast.Symbol;
import sic.ast.directives.DirectiveEQU;
import sic.ast.expression.ExprStar;

public class EvalEQUs
extends Visitor {
    public final boolean relative;

    public EvalEQUs(Program program, ErrorCatcher errorCatcher, boolean bl) {
        super(program, errorCatcher);
        this.relative = bl;
    }

    public void visit(Command command) throws AsmError {
        if (this.relative && command.hasLabel()) {
            this.program.section().symbols.notify(this.program, command.label());
        }
    }

    public void visit(DirectiveEQU directiveEQU) throws AsmError {
        if (directiveEQU.expr instanceof ExprStar && !this.relative) {
            return;
        }
        this.program.section().symbols.update(this.program, directiveEQU.label());
        Symbol symbol = this.program.section().symbols.get(directiveEQU.label());
        if (!symbol.isEvaluated()) {
            return;
        }
        if (!this.relative || directiveEQU.expr.countAddSub() == 0) {
            symbol.setAbsolute(true);
        }
    }
}

