/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.parsing;

import java.util.ArrayList;
import java.util.List;
import sic.asm.AsmError;
import sic.asm.Location;
import sic.asm.Options;
import sic.asm.parsing.Parser;
import sic.ast.Command;
import sic.ast.data.Data;
import sic.ast.data.DataChr;
import sic.ast.data.DataFloat;
import sic.ast.data.DataHex;
import sic.ast.data.DataNum;
import sic.ast.directives.DirectiveBASE;
import sic.ast.directives.DirectiveCSECT;
import sic.ast.directives.DirectiveEND;
import sic.ast.directives.DirectiveEQU;
import sic.ast.directives.DirectiveEXTDEF;
import sic.ast.directives.DirectiveEXTREF;
import sic.ast.directives.DirectiveLTORG;
import sic.ast.directives.DirectiveNOBASE;
import sic.ast.directives.DirectiveORG;
import sic.ast.directives.DirectiveSTART;
import sic.ast.directives.DirectiveUSE;
import sic.ast.expression.Expr;
import sic.ast.instructions.InstructionF1;
import sic.ast.instructions.InstructionF2n;
import sic.ast.instructions.InstructionF2r;
import sic.ast.instructions.InstructionF2rn;
import sic.ast.instructions.InstructionF2rr;
import sic.ast.instructions.InstructionF3;
import sic.ast.instructions.InstructionF3m;
import sic.ast.instructions.InstructionF4m;
import sic.ast.instructions.InstructionLiteral;
import sic.ast.storage.StorageData;
import sic.ast.storage.StorageRes;
import sic.common.Flags;
import sic.common.Mnemonic;

public class OperandParser {
    private final Parser parser;

    public OperandParser(Parser parser) {
        this.parser = parser;
    }

    private void checkWhitespace(String string) throws AsmError {
        this.parser.checkWhitespace("Missing whitespace after mnemonic '%s'", string);
    }

    private List<String> parseSymbols(int n) throws AsmError {
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            String string;
            if ((string = this.parser.readSymbol()).length() > n) {
                throw new AsmError(this.parser.loc(), "Symbol name '%s' too long", string);
            }
            arrayList.add(string);
        } while (this.parser.skipIfComma());
        return arrayList;
    }

    private Expr parseExpression(boolean bl) throws AsmError {
        Expr expr = this.parser.expressionParser.parseExpression();
        if (bl && expr == null) {
            throw new AsmError(this.parser.loc(), "Expression expected '%c'", Character.valueOf(this.parser.peek()));
        }
        return expr;
    }

    public Data parseData(int n, boolean bl) throws AsmError {
        Data data = switch (this.parser.peek()) {
            case 'C' -> new DataChr(n);
            case 'X' -> new DataHex(n);
            case 'F' -> new DataFloat(n);
            default -> new DataNum(n);
        };
        data.parse(this.parser, bl);
        return data;
    }

    private Mnemonic parseLiteralSpec() {
        Mnemonic mnemonic;
        if (this.parser.advanceIf("BYTE") || this.parser.advanceIf('B')) {
            mnemonic = this.parser.mnemonics.get("BYTE");
        } else if (this.parser.advanceIf("FLOT") || this.parser.peek() == 'F') {
            mnemonic = this.parser.mnemonics.get("FLOT");
        } else {
            mnemonic = this.parser.mnemonics.get("WORD");
            this.parser.advanceIf("WORD");
            this.parser.advanceIf('W');
        }
        return mnemonic;
    }

    private StorageData parseLiteralData() throws AsmError {
        Location location = this.parser.loc();
        Mnemonic mnemonic = this.parseLiteralSpec();
        this.parser.skipWhitespace();
        Data data = this.parseData(mnemonic.opcode, false);
        String string = this.parser.program.section().literals.makeUniqLabel();
        return new StorageData(location, string, mnemonic, data);
    }

    private Command parseF1(Location location, String string, Mnemonic mnemonic) {
        return new InstructionF1(location, string, mnemonic);
    }

    private Command parseF2n(Location location, String string, Mnemonic mnemonic) throws AsmError {
        int n = this.parser.readInt(0, 15);
        return new InstructionF2n(location, string, mnemonic, n);
    }

    private Command parseF2r(Location location, String string, Mnemonic mnemonic) throws AsmError {
        int n = this.parser.readRegister();
        return new InstructionF2r(location, string, mnemonic, n);
    }

    private Command parseF2rn(Location location, String string, Mnemonic mnemonic) throws AsmError {
        int n = this.parser.readRegister();
        this.parser.skipComma();
        int n2 = this.parser.readInt(1, 16);
        return new InstructionF2rn(location, string, mnemonic, n, n2);
    }

    private Command parseF2rr(Location location, String string, Mnemonic mnemonic) throws AsmError {
        int n = this.parser.readRegister();
        this.parser.skipComma();
        int n2 = this.parser.readRegister();
        return new InstructionF2rr(location, string, mnemonic, n, n2);
    }

    private Command parseF3(Location location, String string, Mnemonic mnemonic) throws AsmError {
        return new InstructionF3(location, string, mnemonic);
    }

    private Command parseF3m(Location location, String string, Mnemonic mnemonic) throws AsmError {
        String string2;
        int n;
        this.checkWhitespace(mnemonic.name);
        Flags flags = new Flags();
        if (this.parser.advanceIf('=')) {
            InstructionF3m instructionF3m = new InstructionF3m(location, string, mnemonic, new Flags(3, 0), 0, null);
            StorageData storageData = this.parseLiteralData();
            return new InstructionLiteral(instructionF3m, storageData);
        }
        if (this.parser.advanceIf('#')) {
            flags.set_ni(1);
        } else if (this.parser.advanceIf('@')) {
            flags.set_ni(2);
        } else {
            flags.set_ni(3);
        }
        if (Character.isDigit(this.parser.peek()) || this.parser.peek() == '-') {
            n = this.parser.readInt(flags.minOperand(), flags.maxOperand());
            string2 = null;
        } else if (Character.isLetter(this.parser.peek()) || this.parser.peek() == '_') {
            n = 0;
            string2 = this.parser.readSymbol();
        } else if (this.parser.peek() == '*') {
            n = 0;
            string2 = "*";
        } else {
            throw new AsmError(this.parser.loc(), "Invalid character '%c", Character.valueOf(this.parser.peek()));
        }
        if (this.parser.skipIfIndexed()) {
            if (flags.isSimple() || flags.isIndirect() && Options.indirectX) {
                flags.setIndexed();
            } else {
                throw new AsmError(this.parser.loc(), "Indexed addressing not supported here");
            }
        }
        return new InstructionF3m(location, string, mnemonic, flags, n, string2);
    }

    private Command parseF4m(Location location, String string, Mnemonic mnemonic) throws AsmError {
        String string2;
        int n;
        this.checkWhitespace(mnemonic.name);
        Flags flags = new Flags();
        flags.setExtended();
        if (this.parser.advanceIf('=')) {
            InstructionF4m instructionF4m = new InstructionF4m(location, string, mnemonic, new Flags(3, 0), 0, null);
            StorageData storageData = this.parseLiteralData();
            return new InstructionLiteral(instructionF4m, storageData);
        }
        if (this.parser.advanceIf('#')) {
            flags.set_ni(1);
        } else if (this.parser.advanceIf('@')) {
            flags.set_ni(2);
        } else {
            flags.set_ni(3);
        }
        if (Character.isDigit(this.parser.peek()) || this.parser.peek() == '-') {
            n = this.parser.readInt(flags.minOperand(), flags.maxOperand());
            string2 = null;
        } else if (Character.isLetter(this.parser.peek()) || this.parser.peek() == '_') {
            n = 0;
            string2 = this.parser.readSymbol();
        } else if (this.parser.peek() == '*') {
            n = 0;
            string2 = "*";
        } else {
            throw new AsmError(this.parser.loc(), "Invalid character '%c", Character.valueOf(this.parser.peek()));
        }
        if (this.parser.skipIfIndexed()) {
            if (flags.isSimple() || flags.isIndirect() && Options.indirectX) {
                flags.setIndexed();
            } else {
                throw new AsmError(this.parser.loc(), "Indexed addressing not supported here");
            }
        }
        return new InstructionF4m(location, string, mnemonic, flags, n, string2);
    }

    private Command parseD(Location location, String string, Mnemonic mnemonic) throws AsmError {
        switch (mnemonic.opcode) {
            case 2: {
                return new DirectiveCSECT(location, string, mnemonic);
            }
            case 7: {
                return new DirectiveLTORG(location, string, mnemonic);
            }
            case 9: {
                return new DirectiveNOBASE(location, string, mnemonic);
            }
        }
        return null;
    }

    private Command parseDe(Location location, String string, Mnemonic mnemonic) throws AsmError {
        Expr expr = this.parseExpression(true);
        switch (mnemonic.opcode) {
            case 8: {
                return new DirectiveBASE(location, string, mnemonic, expr);
            }
            case 0: {
                return new DirectiveSTART(location, string, mnemonic, expr);
            }
            case 1: {
                return new DirectiveEND(location, string, mnemonic, expr);
            }
            case 10: {
                return new DirectiveEQU(location, string, mnemonic, expr);
            }
        }
        return null;
    }

    private Command parseDe0(Location location, String string, Mnemonic mnemonic) throws AsmError {
        Expr expr = this.parseExpression(false);
        return new DirectiveORG(location, string, mnemonic, expr);
    }

    private Command parseDs0(Location location, String string, Mnemonic mnemonic) throws AsmError {
        String string2 = this.parser.readIfSymbol();
        return new DirectiveUSE(location, string, mnemonic, string2);
    }

    private Command parseDs_(Location location, String string, Mnemonic mnemonic) throws AsmError {
        List<String> list = this.parseSymbols(6);
        switch (mnemonic.opcode) {
            case 5: {
                return new DirectiveEXTDEF(location, string, mnemonic, list);
            }
            case 4: {
                return new DirectiveEXTREF(location, string, mnemonic, list);
            }
        }
        return null;
    }

    private Command parseSe(Location location, String string, Mnemonic mnemonic) throws AsmError {
        Expr expr = this.parseExpression(true);
        return new StorageRes(location, string, mnemonic, expr);
    }

    private Command parseSd(Location location, String string, Mnemonic mnemonic) throws AsmError {
        Data data = this.parseData(mnemonic.opcode, false);
        return new StorageData(location, string, mnemonic, data, false);
    }

    private Command parseSd_(Location location, String string, Mnemonic mnemonic) throws AsmError {
        Data data = this.parseData(mnemonic.opcode, true);
        return new StorageData(location, string, mnemonic, data, false);
    }

    public Command parse(Location location, String string, Mnemonic mnemonic) throws AsmError {
        switch (mnemonic.format) {
            case F1: {
                return this.parseF1(location, string, mnemonic);
            }
            case F2n: {
                return this.parseF2n(location, string, mnemonic);
            }
            case F2r: {
                return this.parseF2r(location, string, mnemonic);
            }
            case F2rn: {
                return this.parseF2rn(location, string, mnemonic);
            }
            case F2rr: {
                return this.parseF2rr(location, string, mnemonic);
            }
            case F3: {
                return this.parseF3(location, string, mnemonic);
            }
            case F3m: {
                return this.parseF3m(location, string, mnemonic);
            }
            case F4m: {
                return this.parseF4m(location, string, mnemonic);
            }
            case D: {
                return this.parseD(location, string, mnemonic);
            }
            case De: {
                return this.parseDe(location, string, mnemonic);
            }
            case De0: {
                return this.parseDe0(location, string, mnemonic);
            }
            case Ds0: {
                return this.parseDs0(location, string, mnemonic);
            }
            case Ds_: {
                return this.parseDs_(location, string, mnemonic);
            }
            case Se: {
                return this.parseSe(location, string, mnemonic);
            }
            case Sd: {
                return this.parseSd(location, string, mnemonic);
            }
            case Sd_: {
                return this.parseSd_(location, string, mnemonic);
            }
        }
        return null;
    }
}

