/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.parsing;

import sic.asm.AsmError;
import sic.asm.Location;

public class Input {
    protected String buf;
    protected int pos;
    protected int row;
    protected int col;
    protected char prev;

    public Input() {
        this.begin(null);
    }

    public void begin(String string) {
        this.buf = string;
        this.pos = 0;
        this.row = 1;
        this.col = 1;
    }

    public int pos() {
        return this.pos;
    }

    public int row() {
        return this.row;
    }

    public int col() {
        return this.col;
    }

    public Location loc() {
        return new Location(this.pos, this.row, this.col);
    }

    public String extract(int n, int n2) {
        return this.buf.substring(n, n2);
    }

    public String extract(int n) {
        return this.buf.substring(n, this.pos);
    }

    public int available() {
        return this.buf.length() - this.pos;
    }

    public boolean ready(int n) {
        return n < this.buf.length();
    }

    public boolean ready() {
        return this.ready(this.pos);
    }

    public char peek(int n) {
        if (this.available() <= n) {
            return '\u0000';
        }
        return this.buf.charAt(this.pos + n);
    }

    public char peek() {
        return this.peek(0);
    }

    public char prev() {
        return this.prev;
    }

    public char advance() {
        this.prev = this.peek();
        ++this.pos;
        switch (this.prev) {
            case '\n': {
                ++this.row;
                this.col = 1;
                break;
            }
            case '\t': {
                this.col = (this.col - 1) / 4 * 4 + 5;
                break;
            }
            default: {
                ++this.col;
            }
        }
        return this.prev;
    }

    public int advance(int n) {
        int n2 = 0;
        while (this.ready() && n2++ < n) {
            this.advance();
        }
        return n2;
    }

    public boolean advanceIf(char c) {
        if (this.peek() != c) {
            return false;
        }
        this.advance();
        return true;
    }

    public void advance(char c) throws AsmError {
        if (this.advanceIf(c)) {
            return;
        }
        throw new AsmError(this.loc(), "Expected '%c'", Character.valueOf(c));
    }

    public boolean advanceIf(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.peek(i) == string.charAt(i)) continue;
            return false;
        }
        this.advance(string.length());
        return true;
    }

    public void advanceUntil(char c) {
        while (this.ready() && this.peek() != c) {
            this.advance();
        }
        this.advance();
    }

    public String readUntil(char c) {
        int n = this.pos;
        this.advanceUntil(c);
        return this.extract(n, this.pos - 1);
    }
}

