/*
 * Decompiled with CFR 0.152.
 */
package sic.asm;

import sic.asm.Location;

public class AsmError
extends Exception
implements Comparable<AsmError> {
    public final Location loc;
    private boolean nonBreaking = false;

    public AsmError(Location location, String string) {
        super(string);
        this.loc = location;
    }

    public AsmError(Location location, String string, Object ... objectArray) {
        this(location, String.format(string, objectArray));
    }

    public AsmError(String string, Object ... objectArray) {
        this(null, string, objectArray);
    }

    public AsmError(Location location, boolean bl, String string, Object ... objectArray) {
        this(location, String.format(string, objectArray));
        this.nonBreaking = bl;
    }

    @Override
    public String toString() {
        String string = this.isBreaking() ? "Error" : "Warning";
        String string2 = string + (String)(this.loc != null ? " at " + this.loc + " (" + this.loc.pos + ")" : "");
        String string3 = this.getLocalizedMessage();
        return (string3 != null ? string2 + ": " + string3 : string2) + ".";
    }

    @Override
    public int compareTo(AsmError asmError) {
        return this.loc.pos - asmError.loc.pos;
    }

    public boolean isBreaking() {
        return !this.nonBreaking;
    }
}

