/*
 * Decompiled with CFR 0.152.
 */
package sic;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import sic.asm.Assembler;
import sic.asm.ErrorCatcher;
import sic.asm.Options;
import sic.ast.Program;
import sic.common.Mnemonics;
import sic.common.Utils;

public class Asm {
    public static final int Version_Major = 2;
    public static final int Version_Minor = 0;
    public static final int Version_Patch = 1;
    private boolean stdin;
    private String input;
    private Writer lstwriter;
    private Writer logwriter;
    private Writer objwriter;

    static void printHelp() {
        System.out.print("Sic/XE Assembler 2.0.1\nUsage: java sic.Asm options parameters\nOptions:\n    -help|-h       Print help.\n    -refshort      Print short assembly reference.\n    -reflong|-ref  Print long assembly reference.\n\n    -obj-dense         Dense object files (without space).\n    -obj-slack         Slack object files (with space).\n    -space-require     Require whitespace after labels and mnemonics.\n    -space-forgo\n    -comment-dot-require  Require dots in comments.\n    -comment-dot-forgo.\n    -indirect-x        Allow indirect indexed addressing.\n");
    }

    void processArgs(String[] stringArray) {
        String string;
        int n;
        if (stringArray.length > 0) {
            if ("-help".equals(stringArray[0]) || "-h".equals(stringArray[0])) {
                Asm.printHelp();
                System.exit(0);
            }
            if ("-refshort".equals(stringArray[0])) {
                new Mnemonics().printReferenceShort();
                System.exit(0);
            }
            if ("-reflong".equals(stringArray[0]) || "-ref".equals(stringArray[0])) {
                new Mnemonics().printReferenceLong();
                System.exit(0);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if ("-obj-dense".equals(string)) {
                Options.addSpaceInObj = false;
            }
            if ("-obj-slack".equals(string)) {
                Options.addSpaceInObj = true;
            }
            if ("-space-require".equals(string)) {
                Options.requireWhitespace = true;
            }
            if ("-space-forgo".equals(string)) {
                Options.requireWhitespace = false;
            }
            if ("-comment-dot-require".equals(string)) {
                Options.requireCommentDot = true;
            }
            if ("-comment-dot-forgo".equals(string)) {
                Options.requireCommentDot = false;
            }
            if ("-indirect-x".equals(string)) {
                Options.indirectX = true;
            }
            if (!string.startsWith("-")) break;
        }
        if (n >= stringArray.length) {
            this.stdin = true;
            this.input = Utils.readStdin();
            this.logwriter = this.lstwriter = new BufferedWriter(new OutputStreamWriter(System.out));
            this.objwriter = this.lstwriter;
            return;
        }
        string = stringArray[n];
        this.input = Utils.readFile(string);
        String string2 = Utils.getFileBasename(string);
        this.lstwriter = Utils.createFileWriter(string2 + ".lst");
        this.logwriter = Utils.createFileWriter(string2 + ".log");
        this.objwriter = Utils.createFileWriter(string2 + ".obj");
    }

    void processSource() {
        Assembler assembler = new Assembler();
        ErrorCatcher errorCatcher = assembler.errorCatcher;
        Program program = assembler.assemble(this.input);
        if (errorCatcher.count() > 0) {
            errorCatcher.print();
            return;
        }
        try {
            if (this.stdin) {
                this.lstwriter.write("******************** Program *******************\n");
            }
            assembler.generateListing(program, this.lstwriter);
            this.lstwriter.flush();
            if (this.stdin) {
                this.logwriter.write("******************** Structure *****************\n");
            }
            assembler.generateLog(program, this.logwriter);
            this.logwriter.flush();
            if (this.stdin) {
                this.objwriter.write("********************** Text ********************\n");
            }
            assembler.generateObj(program, this.objwriter, Options.addSpaceInObj);
            this.objwriter.flush();
            if (!this.stdin) {
                this.lstwriter.close();
                this.logwriter.close();
                this.objwriter.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error while generating files.");
        }
        errorCatcher.print();
    }

    public static void main(String[] stringArray) {
        Asm asm = new Asm();
        asm.processArgs(stringArray);
        asm.processSource();
    }
}

