/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.breakpoints;

import java.security.InvalidParameterException;
import sic.common.Conversion;

public class DataBreakpoint {
    private int from;
    private int to;
    private boolean read = false;
    private boolean write = false;
    private boolean enabled = true;

    private DataBreakpoint(int n, int n2) {
        if (n > n2) {
            throw new InvalidParameterException("Range should be from lower address to higher address!");
        }
        this.from = n;
        this.to = n2;
    }

    public DataBreakpoint(int n, int n2, boolean bl, boolean bl2) {
        this(n, n2);
        this.read = bl;
        this.write = bl2;
    }

    public DataBreakpoint(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this(n, n2, bl, bl2);
        this.enabled = bl3;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setRead(boolean bl) {
        this.read = bl;
    }

    public void setWrite(boolean bl) {
        this.write = bl;
    }

    public void setRange(int n, int n2) {
        if (n > n2) {
            throw new InvalidParameterException("Range should be from lower address to higher address!");
        }
        this.from = n;
        this.to = n2;
    }

    public boolean getRead() {
        return this.read;
    }

    public boolean getWrite() {
        return this.write;
    }

    public void toggleRead() {
        this.read = !this.read;
    }

    public void toggleWrite() {
        this.write = !this.write;
    }

    public boolean addressInside(int n) {
        return this.from <= n && n <= this.to;
    }

    public boolean checkRead(int n) {
        return this.addressInside(n) && this.enabled && this.getRead();
    }

    public boolean checkWrite(int n) {
        return this.addressInside(n) && this.enabled && this.getWrite();
    }

    public Object[] toTable() {
        Object[] objectArray = new Object[]{Conversion.addrToHex(this.from), Conversion.addrToHex(this.to), this.getRead(), this.getWrite(), this.isEnabled()};
        return objectArray;
    }
}

