/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.addons;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import sic.common.Conversion;
import sic.common.GUI;
import sic.common.SICXE;
import sic.sim.Executor;
import sic.sim.vm.Memory;

public class TextualScreen {
    public final int ADDRESS = 47104;
    public final int COLS = 80;
    public final int ROWS = 25;
    public final int FONTSIZE = 12;
    private final Memory memory;
    private int address;
    private int rows;
    private int cols;
    private final JFrame view;
    private JTextArea txtScreen;

    public TextualScreen(Executor executor) {
        this.memory = executor.getMachine().memory;
        this.view = this.createView();
        this.setScreen(47104, 80, 25, 12);
    }

    public void clearScreen() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.memory.setByteRaw(this.address + i * this.cols + j, 32);
            }
        }
    }

    public void setSize(int n, int n2) {
        this.setScreen(this.address, n, n2, this.txtScreen.getFont().getSize());
    }

    public void setScreen(int n, int n2, int n3, int n4) {
        int n5 = 1048575 - n2 * n3;
        if (n > n5) {
            n = n5;
        }
        this.address = n;
        this.rows = n3;
        this.cols = n2;
        this.txtScreen.setRows(n3);
        this.txtScreen.setColumns(n2);
        this.txtScreen.setFont(new Font("monospaced", 1, n4));
        this.updateView();
        this.view.pack();
    }

    private JFrame createView() {
        this.txtScreen = new JTextArea();
        this.txtScreen.setEditable(false);
        this.txtScreen.setToolTipText("Double click to clear screen.");
        this.txtScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TextualScreen.this.clearScreen();
                    TextualScreen.this.updateView();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new BevelBorder(1));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.txtScreen);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(jPanel);
        JFrame jFrame = new JFrame("Screen");
        jFrame.setResizable(false);
        jFrame.setContentPane(jPanel2);
        return jFrame;
    }

    public void updateView() {
        if (this.memory == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                char c = (char)this.memory.getByteRaw(this.address + i * this.cols + j);
                if (c > '\u001f') {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(" ");
            }
            if (i >= this.rows - 1) continue;
            stringBuilder.append("\n");
        }
        this.txtScreen.setText(stringBuilder.toString());
    }

    public void toggleView() {
        this.view.setVisible(!this.view.isVisible());
    }

    public JPanel createSettingsPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2, 0, 0));
        final JTextField jTextField = GUI.createField(jPanel, "Address", Conversion.addrToHex(this.address), 10);
        final JTextField jTextField2 = GUI.createField(jPanel, "Columns", Integer.toString(this.cols), 10);
        final JTextField jTextField3 = GUI.createField(jPanel, "Rows", Integer.toString(this.rows), 10);
        final JTextField jTextField4 = GUI.createField(jPanel, "Font size", Integer.toString(this.txtScreen.getFont().getSize()), 10);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                int n4;
                try {
                    n4 = SICXE.intToAddr(Conversion.hexToInt(jTextField.getText()));
                    n3 = Integer.parseInt(jTextField2.getText());
                    n2 = Integer.parseInt(jTextField3.getText());
                    n = Integer.parseInt(jTextField4.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                TextualScreen.this.setScreen(n4, n3, n2, n);
            }
        };
        jTextField.addActionListener(actionListener);
        jTextField2.addActionListener(actionListener);
        jTextField3.addActionListener(actionListener);
        jTextField4.addActionListener(actionListener);
        return jPanel;
    }
}

