/*
 * Decompiled with CFR 0.152.
 */
package sic.sim;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import sic.asm.Assembler;
import sic.asm.ErrorCatcher;
import sic.ast.Program;
import sic.common.GUI;
import sic.common.SICXE;
import sic.common.Utils;
import sic.disasm.Disassembler;
import sic.link.ui.LinkListener;
import sic.link.ui.LinkerGui;
import sic.loader.Loader;
import sic.sim.Args;
import sic.sim.Executor;
import sic.sim.addons.GraphicalScreen;
import sic.sim.addons.Keyboard;
import sic.sim.addons.TextualScreen;
import sic.sim.views.CPUView;
import sic.sim.views.DataBreakpointView;
import sic.sim.views.DisassemblyView;
import sic.sim.views.MemoryView;
import sic.sim.views.WatchView;

public class MainView {
    private final Executor executor;
    private final Disassembler disassembler;
    private final Args arg;
    private JFrame mainFrame;
    private CPUView cpuView;
    private DisassemblyView disassemblyView;
    private MemoryView memoryView;
    private WatchView watchView;
    private TextualScreen textScreen;
    private GraphicalScreen graphScreen;
    private Keyboard keyboard;
    private DataBreakpointView dataBreakpointView;
    private File lastLoadedFile;

    public MainView(final Executor executor, Disassembler disassembler, Args args) {
        this.executor = executor;
        this.disassembler = disassembler;
        this.arg = args;
        this.cpuView = new CPUView(executor, disassembler);
        this.disassemblyView = new DisassemblyView(executor, disassembler);
        this.memoryView = new MemoryView(executor);
        this.dataBreakpointView = new DataBreakpointView(executor);
        this.watchView = new WatchView(executor, actionEvent -> this.dataBreakpointView.updateView());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.cpuView.mainPanel, "North");
        jPanel.add((Component)this.disassemblyView.mainPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.watchView.mainPanel, "North");
        jPanel2.add((Component)this.memoryView.mainPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        this.mainFrame = new JFrame("SicTools");
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setJMenuBar(this.createMenuBar());
        this.mainFrame.setContentPane(jPanel3);
        this.mainFrame.pack();
        this.mainFrame.setLocation(0, 0);
        this.mainFrame.setVisible(true);
        this.textScreen = new TextualScreen(executor);
        this.graphScreen = new GraphicalScreen(executor);
        this.keyboard = new Keyboard(executor);
        if (args.isTextScr()) {
            this.textScreen.setSize(args.getTextScrCols(), args.getTextScrRows());
            this.textScreen.toggleView();
        }
        if (args.isGraphScr()) {
            this.graphScreen.setSize(args.getGraphScrCols(), args.getGraphScrRows());
            this.graphScreen.toggleView();
        }
        if (args.isKeyb()) {
            this.keyboard.setScreen(SICXE.intToAddr(args.getKeybAddress()));
            this.keyboard.toggleView();
        }
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (MainView.this.mainFrame.isVisible() && executor.hasChanged()) {
                    MainView.this.updateView();
                }
                MainView.this.textScreen.updateView();
            }
        };
        timer.schedule(timerTask, 0L, 50L);
        double d = 1000.0 / (double)(args.getGraphScrFreq() <= 0 ? 120 : args.getGraphScrFreq());
        long l = (long)Math.max(Math.floor(d), 4.0);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MainView.this.graphScreen.updateView();
            }
        }, 0L, l);
    }

    public void updateView() {
        this.cpuView.updateView();
        this.disassemblyView.updateView(!this.executor.isRunning(), !this.executor.isRunning());
        this.memoryView.updateView();
        this.watchView.updateView();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("SicTools");
        GUI.addMenuItem(jMenu, "About", 65, KeyStroke.getKeyStroke(65, 128), actionEvent -> this.showAboutMessage());
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Settings", 83, KeyStroke.getKeyStroke(83, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.showSettingsView();
            }
        });
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Quit", 81, KeyStroke.getKeyStroke(81, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.mainFrame.dispatchEvent(new WindowEvent(MainView.this.mainFrame, 201));
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Machine");
        GUI.addMenuItem(jMenu, "Load asm", 65, KeyStroke.getKeyStroke(79, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = GUI.openFileDialog(MainView.this.mainFrame, new FileNameExtensionFilter("Sic assembler files", "asm"));
                if (file != null) {
                    MainView.this.loadAsm(file);
                }
            }
        });
        GUI.addMenuItem(jMenu, "Load obj", 79, KeyStroke.getKeyStroke(73, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = GUI.openFileDialog(MainView.this.mainFrame, new FileNameExtensionFilter("Sic object files", "obj"));
                if (file != null) {
                    MainView.this.loadObj(file);
                }
            }
        });
        GUI.addMenuItem(jMenu, "Link & load objs", 77, KeyStroke.getKeyStroke(76, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkerGui linkerGui = new LinkerGui(null, null, new LinkListener(){

                    @Override
                    public void onLinked(File file, String string) {
                        if (file != null) {
                            MainView.this.loadObj(file);
                            MainView.this.updateView();
                        } else {
                            LinkerGui.showError(string);
                        }
                    }
                });
                linkerGui.gui();
            }
        });
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Clear all", 67, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.getMachine().registers.reset();
                MainView.this.executor.getMachine().memory.reset();
                MainView.this.executor.getMachine().clearLastExecReadWrite();
                MainView.this.disassemblyView.clearLabelMap();
                MainView.this.watchView.clearLabelMap();
                MainView.this.updateView();
            }
        });
        GUI.addMenuItem(jMenu, "Clear registers", 82, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.getMachine().registers.reset();
                MainView.this.updateView();
            }
        });
        GUI.addMenuItem(jMenu, "Clear memory", 77, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.getMachine().memory.reset();
                MainView.this.executor.getMachine().clearLastExecReadWrite();
                MainView.this.disassemblyView.clearLabelMap();
                MainView.this.watchView.clearLabelMap();
                MainView.this.updateView();
            }
        });
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Clear & reload", 67, KeyStroke.getKeyStroke(82, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.getMachine().registers.reset();
                MainView.this.executor.getMachine().memory.reset();
                MainView.this.executor.getMachine().devices.reset();
                MainView.this.executor.getMachine().clearLastExecReadWrite();
                MainView.this.loadLastLoaded();
                MainView.this.updateView();
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Debug");
        GUI.addMenuItem(jMenu, "Start", 83, KeyStroke.getKeyStroke(116, 0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.start();
            }
        });
        GUI.addMenuItem(jMenu, "Step", 84, KeyStroke.getKeyStroke(117, 0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.step();
            }
        });
        GUI.addMenuItem(jMenu, "Stop", 80, KeyStroke.getKeyStroke(119, 0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.stop();
            }
        });
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Step out", 79, KeyStroke.getKeyStroke(117, 64), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.stepOut();
            }
        });
        GUI.addMenuItem(jMenu, "Run to next line", 78, KeyStroke.getKeyStroke(118, 0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.runToAddress(MainView.this.disassembler.getNextPCLocation());
            }
        });
        GUI.addMenuItem(jMenu, "Run to cursor", 67, KeyStroke.getKeyStroke(115, 0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.executor.runToAddress(MainView.this.disassemblyView.getSelectedAddress());
            }
        });
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Toggle breakpoint", 66, KeyStroke.getKeyStroke(66, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.disassemblyView.toggleBreakpointAtSelectedRow();
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu("View");
        GUI.addMenuItem(jMenu, "Textual screen", 84, KeyStroke.getKeyStroke(84, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.textScreen.toggleView();
            }
        });
        GUI.addMenuItem(jMenu, "Graphical screen", 71, KeyStroke.getKeyStroke(71, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.graphScreen.toggleView();
            }
        });
        GUI.addMenuItem(jMenu, "Keyboard", 75, KeyStroke.getKeyStroke(75, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.keyboard.toggleView();
            }
        });
        jMenu.addSeparator();
        GUI.addMenuItem(jMenu, "Data breakpoints", 68, KeyStroke.getKeyStroke(68, 128), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainView.this.dataBreakpointView.toggleView();
            }
        });
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void load(File file) {
        String string = Utils.getFileExtension(file.getName());
        if ("asm".equals(string)) {
            this.loadAsm(file);
        } else if ("obj".equals(string)) {
            this.loadObj(file);
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, "Invalid filename extension.");
        }
    }

    public void loadObj(File file) {
        this.disassemblyView.clearLabelMap();
        this.watchView.clearLabelMap();
        try {
            FileReader fileReader = new FileReader(file);
            Loader.loadSection(this.executor.machine, fileReader);
            this.lastLoadedFile = file;
            this.mainFrame.setTitle(file.getName());
            this.updateView();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error loading object file.");
            this.updateView();
        }
    }

    public void loadAsm(File file) {
        Assembler assembler = new Assembler();
        ErrorCatcher errorCatcher = assembler.errorCatcher;
        Program program = assembler.assemble(Utils.readFile(file));
        if (errorCatcher.count() > 0) {
            errorCatcher.print();
            if (errorCatcher.shouldEnd()) {
                return;
            }
        }
        StringWriter stringWriter = new StringWriter();
        assembler.generateObj(program, stringWriter, false);
        StringReader stringReader = new StringReader(((Object)stringWriter).toString());
        Loader.loadSection(this.executor.machine, stringReader);
        this.lastLoadedFile = file;
        this.mainFrame.setTitle(file.getName());
        this.disassemblyView.setLabelMap(program.getLabels());
        this.watchView.clearLabelMap();
        this.watchView.setLabelMap(program.getDataLabels());
        if (this.arg.isStats()) {
            System.out.printf("Instructions read: %d\n", program.countInstructions());
        }
        this.updateView();
    }

    private void loadLastLoaded() {
        if (this.lastLoadedFile == null) {
            return;
        }
        this.load(this.lastLoadedFile);
    }

    private JPanel createSettingsGeneralPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 0, 0));
        final JTextField jTextField = GUI.createField(jPanel, "Frequency", Integer.toString(this.executor.getSpeed()), 10);
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainView.this.executor.setSpeed(Integer.parseInt(jTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        return jPanel;
    }

    private void showSettingsView() {
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab("General", null, this.createSettingsGeneralPane(), null);
        jTabbedPane.addTab("Textual screen", null, this.textScreen.createSettingsPane(), null);
        jTabbedPane.addTab("Graphical screen", null, this.graphScreen.createSettingsPane(), null);
        jTabbedPane.addTab("Keyboard", null, this.keyboard.createSettingsPane(), null);
        GUI.showInJFrame("Settings", jTabbedPane, 0, 0);
    }

    private void showAboutMessage() {
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("License");
        jButton.addActionListener(actionEvent -> {
            Window window = SwingUtilities.getWindowAncestor(jButton);
            if (window != null) {
                window.setVisible(false);
            }
        });
        jButton2.addActionListener(actionEvent -> {
            JTextArea jTextArea = new JTextArea("Copyright (c) 2015 Jurij Miheli\u010d\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are met:\n\n1. Redistributions of source code must retain the above copyright notice, this\n   list of conditions and the following disclaimer.\n   2. Redistributions in binary form must reproduce the above copyright notice,\n      this list of conditions and the following disclaimer in the documentation\n\t     and/or other materials provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nhttp://www.opensource.org/licenses/BSD-2-Clause\n\n\nCopyright 1997, 1998 Sun Microsystems, Inc.  All Rights Reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\n  - Redistributions of source code must retain the above copyright\n    notice, this list of conditions and the following disclaimer.\n\n  - Redistributions in binary form must reproduce the above copyright\n    notice, this list of conditions and the following disclaimer in the\n    documentation and/or other materials provided with the distribution.\n\n  - Neither the name of Sun Microsystems nor the names of its\n    contributors may be used to endorse or promote products derived\n    from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jScrollPane.setPreferredSize(new Dimension(500, 500));
            JOptionPane.showMessageDialog(this.mainFrame, jScrollPane, "License", 1);
        });
        Object[] objectArray = new Object[]{jButton2, jButton};
        JOptionPane.showOptionDialog(this.mainFrame, "SicTools: SIC/XE assembler and simulator 2.0.1\n\n(C) 2011-2019, Jurij Miheli\u010d (jurij.mihelic@fri.uni-lj.si)\n\nContributors\nToma\u017e Dobravec (tomaz.dobravec@fri.uni-lj.si)\nNejc Ki\u0161ek\nJakob Erzar\nand others, listed on GitHub", "About", -1, 1, null, objectArray, jButton);
    }
}

