/*
 * Decompiled with CFR 0.152.
 */
package sic.link;

import java.io.File;
import sic.link.LinkerError;

public class Options {
    private static final String PHASE = "options";
    private String outputName = null;
    private String outputPath = null;
    private boolean force = false;
    private String main = null;
    private boolean verbose = false;
    private boolean keep = false;
    private boolean graphical = false;
    private boolean editing = false;

    public Options() {
    }

    public Options(String string, boolean bl, String string2, boolean bl2, boolean bl3) throws LinkerError {
        this.force = bl;
        this.main = string2;
        this.verbose = bl2;
        this.keep = bl3;
        File file = new File(string);
        if (file.isDirectory() || file.getParentFile() != null && !file.getParentFile().exists()) {
            throw new LinkerError(PHASE, string + " is not a valid output file");
        }
        this.outputName = file.getName();
        this.outputPath = file.getAbsolutePath();
    }

    public int processFlags(String[] stringArray) throws LinkerError {
        String string;
        int n = 0;
        block27: for (int i = 0; i < stringArray.length && (string = stringArray[i]).startsWith("-"); ++i) {
            switch (string) {
                case "-o": 
                case "-out": {
                    if (++i == stringArray.length) {
                        throw new LinkerError(PHASE, "Output file name not specified. Use -h option for help.");
                    }
                    String string2 = stringArray[i];
                    File file = new File(string2);
                    if (file.isDirectory() || file.getParentFile() != null && !file.getParentFile().exists()) {
                        throw new LinkerError(PHASE, string2 + " is not a valid output file");
                    }
                    this.outputName = file.getName();
                    this.outputPath = file.getAbsolutePath();
                    n += 2;
                    continue block27;
                }
                case "-f": 
                case "-force": {
                    this.force = true;
                    ++n;
                    continue block27;
                }
                case "-k": 
                case "-keep": {
                    this.keep = true;
                    ++n;
                    continue block27;
                }
                case "-m": 
                case "-main": {
                    if (++i == stringArray.length) {
                        throw new LinkerError(PHASE, "Main section name not specified. Use -h option for help.");
                    }
                    this.main = stringArray[i];
                    n += 2;
                    continue block27;
                }
                case "-v": 
                case "-verbose": {
                    this.verbose = true;
                    ++n;
                    continue block27;
                }
                case "-g": 
                case "-ui": {
                    this.graphical = true;
                    ++n;
                    continue block27;
                }
                case "-e": 
                case "-edit": {
                    this.editing = true;
                    ++n;
                    continue block27;
                }
                default: {
                    System.out.println("SIC/XE Linker");
                    System.out.println();
                    System.out.println("Links given relative object files, resolving the references between them using the R and D records. The result is an .obj file, with one relative control section that can be loaded and executed.");
                    System.out.println();
                    System.out.println("Usage:");
                    System.out.println("java sic.Link <options> <input files> ");
                    System.out.println();
                    System.out.println("Linker options:");
                    System.out.println("-o <path to a file> : specifies the output file");
                    System.out.println("-m <section name> : specifies the main/starting section");
                    System.out.println();
                    System.out.println("-f : force linking even if not all references can be resolved");
                    System.out.println("-k : keep D records in the output file");
                    System.out.println("-v : display debugging messages during linking");
                    System.out.println("-g : displays a graphical interface");
                    System.out.println();
                    System.out.println("-h : shows this help");
                    throw new LinkerError();
                }
            }
        }
        return n;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputName(String string) {
        this.outputName = string;
    }

    public void setOutputPath(String string) {
        this.outputPath = string;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public String getMain() {
        return this.main;
    }

    public void setMain(String string) {
        this.main = string;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public boolean isGraphical() {
        return this.graphical;
    }

    public void setGraphical(boolean bl) {
        this.graphical = bl;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
    }

    public String describeOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.main != null) {
            stringBuilder.append(" -m " + this.main);
        }
        if (this.force) {
            stringBuilder.append(" -f");
        }
        if (this.verbose) {
            stringBuilder.append(" -v");
        }
        if (this.keep) {
            stringBuilder.append(" -k");
        }
        return stringBuilder.toString();
    }

    public void copyFrom(Options options) {
        this.outputName = options.getOutputName();
        this.outputPath = options.getOutputPath();
        this.force = options.isForce();
        this.main = options.getMain();
        this.verbose = options.isVerbose();
        this.keep = options.isKeep();
        this.graphical = options.isGraphical();
        this.editing = options.isEditing();
    }
}

