/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.instructions;

import sic.asm.Location;
import sic.ast.instructions.InstructionF2Base;
import sic.common.Conversion;
import sic.common.Mnemonic;

public class InstructionF2n
extends InstructionF2Base {
    public final int number;

    public InstructionF2n(Location location, String string, Mnemonic mnemonic, int n) {
        super(location, string, mnemonic);
        this.number = n;
    }

    @Override
    public String operandToString() {
        return Integer.toString(this.number);
    }

    @Override
    public void emitRawCode(byte[] byArray, int n) {
        this.emitRawCode(byArray, n, this.number, 0);
    }

    @Override
    public String explain() {
        return "<b>Hex:</b> " + Conversion.byteToHex(this.mnemonic.opcode) + " " + Conversion.byteToHex(this.number << 4) + "<br><b>Bin:</b> " + Conversion.byteToBin(this.mnemonic.opcode) + " " + Conversion.byteToBin(this.number << 4);
    }
}

