/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.data;

import sic.asm.AsmError;
import sic.asm.parsing.Parser;
import sic.ast.data.Data;

public class DataChr
extends Data {
    public DataChr(int n) {
        super(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.data.length + 3);
        stringBuilder.append("C'");
        for (byte by : this.data) {
            stringBuilder.append((char)by);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString() + super.toString();
    }

    @Override
    public void parse(Parser parser, boolean bl) throws AsmError {
        parser.advance('C');
        char c = parser.advance();
        switch (c) {
            case '\'': {
                this.data = parser.readUntil('\'').getBytes();
                break;
            }
            case '\"': {
                this.data = parser.readEscapedString('\"').getBytes();
                break;
            }
            default: {
                throw new AsmError(parser.loc(), "Expected quote");
            }
        }
        if (bl) {
            super.parse(parser, true);
        }
    }
}

