/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.parsing;

import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.asm.Location;
import sic.asm.Options;
import sic.asm.parsing.ExpressionParser;
import sic.asm.parsing.Lexer;
import sic.asm.parsing.OperandParser;
import sic.ast.Command;
import sic.ast.Comment;
import sic.ast.Program;
import sic.common.Mnemonic;
import sic.common.Mnemonics;

public class Parser
extends Lexer {
    public final Mnemonics mnemonics;
    public final OperandParser operandParser;
    public final ExpressionParser expressionParser;
    public final ErrorCatcher errorCatcher;
    protected Program program;

    public Parser(Mnemonics mnemonics, ErrorCatcher errorCatcher) {
        this.mnemonics = mnemonics;
        this.operandParser = new OperandParser(this);
        this.expressionParser = new ExpressionParser(this, true);
        this.errorCatcher = errorCatcher;
    }

    public void checkWhitespace(String string, Object ... objectArray) throws AsmError {
        if (Options.requireWhitespace) {
            if (this.available() <= 0) {
                throw new AsmError(this.loc(), true, "Empty label %s at the end", objectArray);
            }
            if (!Character.isWhitespace(this.prev)) {
                throw new AsmError(this.loc(), string, objectArray);
            }
        }
    }

    public Command parseIfCommand() throws AsmError {
        Location location = this.loc();
        String string = this.readIfLabel();
        this.skipWhitespace();
        if (string != null) {
            this.skipLinesAndComments();
            this.checkWhitespace("Missing whitespace after label '%s'", string);
        } else {
            location = this.loc();
        }
        String string2 = this.readIfMnemonic();
        if (string2 == null) {
            if (string == null) {
                return null;
            }
            throw new AsmError(this.loc(), "Missing mnemonic");
        }
        Mnemonic mnemonic = this.mnemonics.get(string2);
        if (mnemonic == null) {
            throw new AsmError(this.loc(), "Invalid mnemonic '%s'", string2);
        }
        this.skipWhitespace();
        return this.operandParser.parse(location, string, mnemonic);
    }

    public Program parseProgram() {
        this.program = new Program();
        while (this.ready() && this.col > 1) {
            this.advanceUntil('\n');
        }
        while (this.ready()) {
            String string;
            Command command;
            Location location;
            block11: {
                assert (this.col() == 1);
                location = this.loc();
                try {
                    command = this.parseIfCommand();
                    this.skipWhitespace();
                    string = this.readIfComment(Options.requireCommentDot, Options.skipEmptyLines);
                    if (command != null || string != null) break block11;
                    this.advance('\n');
                }
                catch (AsmError asmError) {
                    this.errorCatcher.add(asmError);
                    this.advanceUntil('\n');
                    continue;
                }
            }
            try {
                if (command != null) {
                    command.setComment(string);
                    command.append(this.program);
                    continue;
                }
                if (string != null) {
                    command = new Comment(location, string);
                    command.append(this.program);
                    continue;
                }
                if (Options.skipEmptyLines) continue;
                command = new Comment(location, "");
                command.append(this.program);
            }
            catch (AsmError asmError) {
                this.errorCatcher.add(asmError);
            }
        }
        try {
            this.program.flushAllLiterals();
        }
        catch (AsmError asmError) {
            this.errorCatcher.add(asmError);
        }
        return this.program;
    }
}

