/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.parsing;

import sic.asm.AsmError;
import sic.asm.Location;
import sic.asm.parsing.Parser;
import sic.ast.expression.Expr;
import sic.ast.expression.ExprInt;
import sic.ast.expression.ExprOp;
import sic.ast.expression.ExprSym;

public class ExpressionParser {
    private final Parser parser;
    public final boolean allowSymbols;
    private Expr nextTok;

    public ExpressionParser(Parser parser, boolean bl) {
        this.parser = parser;
        this.allowSymbols = bl;
    }

    private Expr readToken() throws AsmError {
        this.parser.skipWhitespace();
        Location location = this.parser.loc();
        if (Character.isDigit(this.parser.peek())) {
            return new ExprInt(location, this.parser.readInt(0, 0xFFFFFF));
        }
        if (this.allowSymbols && Character.isLetter(this.parser.peek())) {
            return new ExprSym(location, this.parser.readSymbol());
        }
        if (this.parser.advanceIf('+')) {
            return new ExprOp("+", location, 10);
        }
        if (this.parser.advanceIf('-')) {
            return new ExprOp("-", location, 10);
        }
        if (this.parser.advanceIf('*')) {
            return new ExprOp("*", location, 20);
        }
        if (this.parser.advanceIf('/')) {
            return new ExprOp("/", location, 20);
        }
        if (this.parser.advanceIf('%')) {
            return new ExprOp("%", location, 20);
        }
        return null;
    }

    public Expr parseExpression() throws AsmError {
        this.nextTok = this.readToken();
        if (this.nextTok == null) {
            return null;
        }
        return this.parseExpression(0);
    }

    public Expr parseExpression(int n) throws AsmError {
        Expr expr = this.nextTok;
        this.nextTok = this.readToken();
        Expr expr2 = expr.parse(this);
        while (this.nextTok != null && this.nextTok.leftBP > n) {
            expr = this.nextTok;
            this.nextTok = this.readToken();
            expr2 = expr.parseLeft(this, expr2);
        }
        return expr2;
    }
}

