/*
 * Decompiled with CFR 0.152.
 */
package sic.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sic.asm.AsmError;

public class ErrorCatcher {
    public final List<AsmError> errs = new ArrayList<AsmError>();
    private int lastPrinted;

    public void clear() {
        this.errs.clear();
        this.lastPrinted = 0;
    }

    public int count() {
        return this.errs.size();
    }

    public void add(AsmError asmError) {
        this.errs.add(asmError);
        Collections.sort(this.errs);
    }

    public void printByRow(int n) {
        for (AsmError asmError : this.errs) {
            if (asmError.loc.row != n) continue;
            System.err.println(asmError);
        }
    }

    public void print() {
        while (this.lastPrinted < this.errs.size()) {
            AsmError asmError = this.errs.get(this.lastPrinted);
            System.err.println(asmError);
            ++this.lastPrinted;
        }
    }

    public boolean shouldEnd() {
        return this.errs.stream().anyMatch(AsmError::isBreaking);
    }
}

