/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.vm;

import sic.common.Conversion;
import sic.common.Logger;
import sic.sim.vm.Device;
import sic.sim.vm.FileDevice;
import sic.sim.vm.InputDevice;
import sic.sim.vm.OutputDevice;

public class Devices {
    private Device[] devices;

    public Device getDevice(int n) {
        return this.devices[n];
    }

    public void setDevice(int n, Device device) {
        this.devices[n] = device;
    }

    private boolean checkDeviceIndex(int n) {
        boolean bl;
        boolean bl2 = bl = n < 0 || n >= this.devices.length;
        if (bl) {
            Logger.fmterr("Invalid device number '%d'.", n);
        }
        return bl;
    }

    public int read(int n) {
        if (this.checkDeviceIndex(n)) {
            Logger.fmterr("Invalid device number '%d'.", n);
            return 0;
        }
        int n2 = this.devices[n].read();
        if (n2 < 0 || n2 > 255) {
            n2 = 0;
        }
        return n2;
    }

    public void write(int n, int n2) {
        if (this.checkDeviceIndex(n)) {
            Logger.fmterr("Invalid device number '%d'.", n);
        } else {
            this.devices[n].write(n2 & 0xFF);
        }
    }

    public boolean test(int n) {
        if (this.checkDeviceIndex(n)) {
            Logger.fmterr("Invalid device number '%d'.", n);
            return false;
        }
        return this.devices[n].test();
    }

    public void reset() {
        for (int i = 3; i < this.devices.length; ++i) {
            this.devices[i].reset();
        }
    }

    public Devices(int n) {
        assert (n > 2);
        this.devices = new Device[n];
        this.setDevice(0, new InputDevice(System.in));
        this.setDevice(1, new OutputDevice(System.out));
        this.setDevice(2, new OutputDevice(System.err));
        for (int i = 3; i < n; ++i) {
            this.setDevice(i, new FileDevice(Conversion.byteToHex(i) + ".dev"));
        }
    }
}

