/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreePath;
import sic.ast.StorageSymbol;
import sic.sim.Executor;
import sic.sim.breakpoints.DataBreakpoint;
import sic.sim.views.SymbolChild;
import sic.sim.views.SymbolNode;
import sic.sim.views.WatchRoot;
import sic.sim.views.WatchTreeTableModel;
import sic.sim.views.components.treetable.JTreeTable;
import sic.sim.vm.Memory;

public class WatchView {
    public JPanel mainPanel;
    private JTreeTable treeTable;
    private WatchTreeTableModel treeTableModel;
    private Memory memory;
    private ActionListener updateBreakpointsEvent;
    private HashMap<Integer, StorageSymbol> labelMap = new HashMap();
    private ArrayList<StorageSymbol> symbols;
    private int[] indicies;
    private HashMap<StorageSymbol, DataBreakpoint> breakpoints = new HashMap();

    public WatchView(Executor executor, ActionListener actionListener) {
        this.$$$setupUI$$$();
        this.memory = executor.machine.memory;
        this.updateBreakpointsEvent = actionListener;
        this.treeTableModel.setMemory(this.memory);
    }

    public void setLabelMap(HashMap<Integer, StorageSymbol> hashMap) {
        this.labelMap = hashMap;
        TreeMap<Integer, StorageSymbol> treeMap = new TreeMap<Integer, StorageSymbol>(hashMap);
        this.symbols = new ArrayList(hashMap.size());
        for (Integer n : treeMap.keySet()) {
            this.symbols.add(hashMap.get(n));
        }
        this.treeTableModel.updateSymbols(this.symbols);
        if (this.symbols.size() > 0) {
            this.indicies = this.generateIndices(this.symbols.size());
            this.treeTableModel.fireTreeNodesInserted(this, null, this.indicies, this.symbols.toArray());
            this.treeTable.getTree().expandPath(new TreePath(this.treeTableModel.getRoot()));
        }
    }

    public void clearLabelMap() {
        HashMap<Integer, StorageSymbol> hashMap = this.labelMap;
        this.labelMap = new HashMap();
        this.symbols = new ArrayList<StorageSymbol>(hashMap.values());
        this.treeTableModel.updateSymbols(new ArrayList<StorageSymbol>());
        if (this.symbols.size() > 0) {
            this.indicies = this.generateIndices(this.symbols.size());
            this.treeTableModel.fireTreeNodesRemoved(this, null, this.indicies, this.symbols.toArray());
            this.symbols = new ArrayList();
            for (DataBreakpoint dataBreakpoint : this.breakpoints.values()) {
                this.memory.dataBreakpoints.remove(dataBreakpoint);
            }
            this.breakpoints = new HashMap();
        }
    }

    private void refreshNodes() {
        if (this.symbols != null && this.symbols.size() > 0) {
            this.treeTableModel.fireTreeNodesChanged(this, null, this.indicies, this.symbols.toArray());
        }
    }

    public void updateView() {
        this.refreshNodes();
    }

    private void createUIComponents() {
        this.treeTableModel = new WatchTreeTableModel(this.memory);
        this.treeTable = new JTreeTable(this.treeTableModel);
        this.initTreeTable();
    }

    private int[] generateIndices(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void initTreeTable() {
        this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Toggle read breakpoint");
        JMenuItem jMenuItem2 = new JMenuItem("Toggle write breakpoint");
        JMenuItem jMenuItem3 = new JMenuItem("Toggle read & write breakpoint");
        jMenuItem.addActionListener(actionEvent -> this.toggleWatchBreakpoint(true, false));
        jMenuItem2.addActionListener(actionEvent -> this.toggleWatchBreakpoint(false, true));
        jMenuItem3.addActionListener(actionEvent -> this.toggleWatchBreakpoint(true, true));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                SwingUtilities.invokeLater(() -> {
                    int n = WatchView.this.treeTable.rowAtPoint(SwingUtilities.convertPoint(jPopupMenu, new Point(0, 0), WatchView.this.treeTable));
                    if (n > -1) {
                        WatchView.this.treeTable.setRowSelectionInterval(n, n);
                        WatchView.this.treeTable.getTree().setSelectionRow(n);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.treeTable.setComponentPopupMenu(jPopupMenu);
    }

    private void toggleWatchBreakpoint(boolean bl, boolean bl2) {
        StorageSymbol storageSymbol;
        Object object = this.treeTable.getTree().getLastSelectedPathComponent();
        if (object instanceof WatchRoot) {
            return;
        }
        if (object instanceof SymbolNode) {
            storageSymbol = ((SymbolNode)object).getSymbol();
        } else if (object instanceof SymbolChild) {
            storageSymbol = ((SymbolChild)object).symbol;
        } else {
            return;
        }
        DataBreakpoint dataBreakpoint = this.breakpoints.get(storageSymbol);
        if (dataBreakpoint == null) {
            int n = storageSymbol.value();
            int n2 = n + storageSymbol.getElementCount() * storageSymbol.getElementSize() - 1;
            DataBreakpoint dataBreakpoint2 = new DataBreakpoint(n, n2, bl, bl2);
            this.breakpoints.put(storageSymbol, dataBreakpoint2);
            this.memory.dataBreakpoints.add(dataBreakpoint2);
        } else {
            if (bl) {
                dataBreakpoint.toggleRead();
            }
            if (bl2) {
                dataBreakpoint.toggleWrite();
            }
        }
        this.updateBreakpointsEvent.actionPerformed(null);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setMinimumSize(new Dimension(50, 200));
        this.mainPanel.setPreferredSize(new Dimension(100, 200));
        this.mainPanel.setRequestFocusEnabled(true);
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Watch", 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(98, 120));
        this.mainPanel.add((Component)jScrollPane, "Center");
        Font font = this.$$$getFont$$$("Lucida Console", -1, -1, this.treeTable.getFont());
        if (font != null) {
            this.treeTable.setFont(font);
        }
        jScrollPane.setViewportView(this.treeTable);
    }

    private Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

