/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import sic.ast.StorageSymbol;
import sic.common.Conversion;
import sic.sim.views.SymbolChild;
import sic.sim.views.SymbolNode;
import sic.sim.views.WatchRoot;
import sic.sim.views.components.treetable.TreeTableModel;
import sic.sim.vm.Memory;

class WatchTreeTableModel
implements TreeTableModel {
    private String[] columnNames = new String[]{"Name", "Address", "Decimal", "Hex", "Char"};
    private Class[] columnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class};
    private WatchRoot root;
    private Memory memory;
    private EventListenerList listenerList = new EventListenerList();

    WatchTreeTableModel(Memory memory) {
        this.memory = memory;
        this.root = new WatchRoot(new ArrayList<StorageSymbol>());
    }

    public void updateSymbols(List<StorageSymbol> list) {
        this.root.setSymbols(list);
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        int n2;
        StorageSymbol storageSymbol;
        if (object instanceof WatchRoot) {
            switch (n) {
                case 0: {
                    return "Watch";
                }
            }
            return "";
        }
        if (object instanceof SymbolNode) {
            storageSymbol = ((SymbolNode)object).getSymbol();
            n2 = storageSymbol.value();
        } else {
            storageSymbol = ((SymbolChild)object).symbol;
            n2 = storageSymbol.value() + ((SymbolChild)object).index;
        }
        switch (n) {
            case 0: {
                return storageSymbol.name;
            }
            case 1: {
                return Conversion.addrToHex(n2);
            }
            case 2: {
                switch (storageSymbol.getDataType()) {
                    case BYTE: {
                        return Integer.toString(this.memory.getByteRaw(n2));
                    }
                    case WORD: {
                        return Integer.toString(this.memory.getWordRaw(n2));
                    }
                    case FLOAT: {
                        return Double.toString(this.memory.getFloatRaw(n2));
                    }
                }
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder(storageSymbol.getElementSize() * 2);
                for (int i = 0; i < storageSymbol.getElementSize(); ++i) {
                    stringBuilder.append(String.format("%02X", this.memory.getByteRaw(n2 + i)));
                }
                return stringBuilder.toString();
            }
            case 4: {
                switch (storageSymbol.getDataType()) {
                    case BYTE: {
                        return Character.valueOf((char)this.memory.getByteRaw(n2));
                    }
                    case WORD: {
                        return Character.valueOf((char)this.memory.getWordRaw(n2));
                    }
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return this.columnTypes[n] == TreeTableModel.class;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object instanceof WatchRoot) {
            return this.root.getSymbols().get(n);
        }
        if (object instanceof SymbolNode) {
            return ((SymbolNode)object).getChildren().get(n);
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof WatchRoot) {
            return this.root.getSymbols().size();
        }
        if (object instanceof SymbolNode) {
            return ((SymbolNode)object).getChildrenCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof SymbolNode) {
            return ((SymbolNode)object).getChildrenCount() == 0;
        }
        if (object instanceof WatchRoot) {
            return ((WatchRoot)object).getSymbols().size() == 0;
        }
        return object instanceof SymbolChild;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        block3: {
            block2: {
                if (!(object instanceof WatchRoot)) break block2;
                for (int i = 0; i < this.root.getSymbols().size(); ++i) {
                    if (this.root.getSymbols().get(i) != object2) continue;
                    return i;
                }
                break block3;
            }
            if (!(object instanceof SymbolNode)) break block3;
            SymbolNode symbolNode = (SymbolNode)object;
            for (int i = 0; i < symbolNode.getChildrenCount(); ++i) {
                if (symbolNode.getChildren().get(i) != object2) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }
}

