/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import sic.ast.Command;
import sic.ast.Symbol;
import sic.common.Conversion;
import sic.common.SICXE;
import sic.disasm.Disassembler;
import sic.sim.Colors;
import sic.sim.Executor;
import sic.sim.breakpoints.Breakpoints;
import sic.sim.views.BreakpointIconCellRenderer;
import sic.sim.views.CellRenderer;
import sic.sim.vm.Machine;

public class DisassemblyView {
    public static final int MOVE_SMALL = 1;
    private static final int ROW_AMOUNT = 19;
    private Executor executor;
    private Machine machine;
    private Breakpoints breakpoints;
    private Disassembler disassembler;
    private DefaultTableModel modelDis;
    public JPanel mainPanel;
    private JButton btnUp;
    private JButton btnDn;
    private JButton btnPC;
    private JTextField txtLoc;
    private JTable tabDis;
    private HashMap<Integer, Symbol> labelMap;

    public DisassemblyView(Executor executor, final Disassembler disassembler) {
        this.executor = executor;
        this.machine = executor.machine;
        this.breakpoints = executor.breakpoints;
        this.disassembler = disassembler;
        this.labelMap = new HashMap();
        this.$$$setupUI$$$();
        this.modelDis = (DefaultTableModel)this.tabDis.getModel();
        this.modelDis.setRowCount(19);
        this.modelDis.setColumnCount(7);
        this.tabDis.setBackground(Colors.bg);
        this.tabDis.setForeground(Colors.fg);
        this.tabDis.setSelectionBackground(Colors.selectionBg);
        this.tabDis.setSelectionForeground(Colors.selectionFg);
        this.tabDis.setSelectionMode(0);
        CellRenderer cellRenderer = new CellRenderer();
        for (int i = 1; i < this.tabDis.getColumnCount(); ++i) {
            this.tabDis.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
        }
        this.tabDis.getColumnModel().getColumn(0).setCellRenderer(new BreakpointIconCellRenderer());
        this.tabDis.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.tabDis.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.tabDis.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tabDis.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.tabDis.getColumnModel().getColumn(3).setMinWidth(0);
        this.tabDis.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.tabDis.getColumnModel().getColumn(5).setPreferredWidth(120);
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisassemblyView.this.disMove(-1);
            }
        });
        this.btnDn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisassemblyView.this.disMove(1);
            }
        });
        this.btnPC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                disassembler.gotoPC();
                DisassemblyView.this.updateDis(true, false);
            }
        });
        this.txtLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                disassembler.setLocation(SICXE.intToAddr(Conversion.hexToInt(DisassemblyView.this.txtLoc.getText())));
                DisassemblyView.this.updateDis(true, false);
            }
        });
        this.tabDis.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        int n = DisassemblyView.this.tabDis.rowAtPoint(mouseEvent.getPoint());
                        int n2 = DisassemblyView.this.tabDis.columnAtPoint(mouseEvent.getPoint());
                        if (n2 != 0) {
                            return;
                        }
                        int n3 = SICXE.intToAddr(Conversion.hexToInt((String)DisassemblyView.this.tabDis.getValueAt(n, 1)));
                        DisassemblyView.this.breakpoints.toggleBreakpoint(n3);
                        DisassemblyView.this.updateBreakpoint(n, DisassemblyView.this.breakpoints.has(n3));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                super.mouseClicked(mouseEvent);
            }
        });
        this.tabDis.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                DisassemblyView.this.disMove(mouseWheelEvent.getWheelRotation());
                super.mouseWheelMoved(mouseWheelEvent);
            }
        });
        this.tabDis.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.tabDis.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.tabDis.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "space");
        this.tabDis.getActionMap().put("up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DisassemblyView.this.tabDis.getSelectedRow();
                if (n < 0) {
                    return;
                }
                if (--n < 0) {
                    n = 0;
                    disassembler.prev();
                    DisassemblyView.this.updateDis(false, false);
                }
                DisassemblyView.this.tabDis.setRowSelectionInterval(n, n);
            }
        });
        this.tabDis.getActionMap().put("down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DisassemblyView.this.tabDis.getSelectedRow();
                if (n < 0) {
                    return;
                }
                if (++n >= DisassemblyView.this.tabDis.getRowCount()) {
                    n = DisassemblyView.this.tabDis.getRowCount() - 1;
                    if ("".equals(DisassemblyView.this.tabDis.getValueAt(n, 1))) {
                        return;
                    }
                    disassembler.next();
                    DisassemblyView.this.updateDis(false, false);
                }
                DisassemblyView.this.tabDis.setRowSelectionInterval(n, n);
            }
        });
        this.tabDis.getActionMap().put("space", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DisassemblyView.this.tabDis.getSelectedRow();
                if (n < 0) {
                    return;
                }
                String string = (String)DisassemblyView.this.tabDis.getValueAt(n, 1);
                if ("".equals(string)) {
                    return;
                }
                int n2 = SICXE.intToAddr(Conversion.hexToInt(string));
                DisassemblyView.this.breakpoints.toggleBreakpoint(n2);
                DisassemblyView.this.updateBreakpoint(n, DisassemblyView.this.breakpoints.has(n2));
            }
        });
    }

    private void createUIComponents() {
        this.tabDis = new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }

    private void updateBreakpoint(int n, boolean bl) {
        this.modelDis.setValueAt(bl ? "1" : "", n, 0);
    }

    private void clearDisLine(int n) {
        this.modelDis.setValueAt("", n, 1);
        this.modelDis.setValueAt("", n, 2);
        this.modelDis.setValueAt("", n, 3);
        this.modelDis.setValueAt("", n, 4);
        this.modelDis.setValueAt("", n, 5);
        this.modelDis.setValueAt("", n, 6);
    }

    private void updateDisLine(int n, int n2, Command command) {
        this.updateBreakpoint(n, this.breakpoints.has(n2));
        this.modelDis.setValueAt(Conversion.addrToHex(n2), n, 1);
        this.modelDis.setValueAt(Conversion.bytesToHex(this.machine.memory.memory, n2, command.size()), n, 2);
        this.modelDis.setValueAt(this.toLabel(n2), n, 3);
        this.modelDis.setValueAt(command.nameToString(), n, 4);
        this.modelDis.setValueAt(command.operandToString(), n, 5);
        Integer n3 = command.resolveOperandAddress(n2);
        if (n3 != null) {
            Object object = this.toLabel(n3).equals("") ? "0x" + Conversion.addrToHex(n3) : this.toLabel(n3);
            this.modelDis.setValueAt("=" + (String)object, n, 6);
        } else {
            this.modelDis.setValueAt("", n, 6);
        }
    }

    public void updateDis(boolean bl, boolean bl2) {
        if (this.tabDis.getRowCount() <= 0) {
            bl2 = false;
        }
        int n = this.disassembler.location();
        for (int i = 0; i < this.tabDis.getRowCount(); ++i) {
            if (n > 1048575) {
                this.clearDisLine(i);
                continue;
            }
            if (bl && n == this.machine.registers.getPC()) {
                if (this.tabDis.getRowCount() > 1) {
                    int n2 = Math.min(this.tabDis.getRowCount() - 1, 2);
                    if (this.getAddressAtRow(this.tabDis.getRowCount() - n2) == this.machine.registers.getPC()) {
                        this.disMove(1);
                        this.updateDis(true, false);
                        return;
                    }
                }
                this.tabDis.setRowSelectionInterval(i, i);
                bl2 = false;
            }
            Command command = this.disassembler.disassembleSafe(n);
            this.updateDisLine(i, n, command);
            n += command.size();
        }
        if (bl2) {
            this.disassembler.gotoPC();
            this.updateDis(true, false);
        }
        this.txtLoc.setText(Conversion.addrToHex(this.disassembler.location()));
    }

    public void updateView(boolean bl, boolean bl2) {
        this.updateDis(bl, bl2);
    }

    private void disMove(int n) {
        boolean bl = this.isAtDissasemblyBorder();
        if (n > 0) {
            this.disassembler.next(n);
        } else {
            this.disassembler.prev(-n);
        }
        this.updateDis(false, false);
        if (!(this.tabDis.getSelectedRow() == -1 || bl && this.isAtDissasemblyBorder())) {
            int n2 = this.tabDis.getSelectedRow() - n;
            if (n2 >= 0 && n2 < this.tabDis.getRowCount()) {
                this.tabDis.setRowSelectionInterval(n2, n2);
            } else {
                this.tabDis.clearSelection();
            }
        }
    }

    public void toggleBreakpointAtSelectedRow() {
        int n = this.tabDis.getSelectedRow();
        int n2 = SICXE.intToAddr(Conversion.hexToInt((String)this.tabDis.getValueAt(n, 1)));
        this.breakpoints.toggleBreakpoint(n2);
        this.updateBreakpoint(n, this.breakpoints.has(n2));
    }

    public int getAddressAtRow(int n) {
        if (n < 0 || n >= this.tabDis.getRowCount()) {
            return -1;
        }
        return SICXE.intToAddr(Conversion.hexToInt((String)this.tabDis.getValueAt(n, 1)));
    }

    public int getSelectedAddress() {
        int n = this.tabDis.getSelectedRow();
        return this.getAddressAtRow(n);
    }

    public boolean isAtDissasemblyBorder() {
        int n = this.getAddressAtRow(0);
        return n == 0 || n == 1048575;
    }

    public void setLabelMap(HashMap<Integer, Symbol> hashMap) {
        this.labelMap = hashMap;
        this.tabDis.getColumnModel().getColumn(3).setPreferredWidth(60);
    }

    public void clearLabelMap() {
        this.labelMap = new HashMap();
        this.tabDis.getColumnModel().getColumn(3).setPreferredWidth(0);
    }

    private String toLabel(int n) {
        if (!this.labelMap.containsKey(n)) {
            return "";
        }
        return this.labelMap.get((Object)Integer.valueOf((int)n)).name;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Disassembly", 0, 0, null, null));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.mainPanel.add((Component)jPanel, "South");
        this.btnUp = new JButton();
        this.btnUp.setText("<");
        jPanel.add(this.btnUp);
        this.txtLoc = new JTextField();
        this.txtLoc.setColumns(5);
        this.txtLoc.setText("00000");
        jPanel.add(this.txtLoc);
        this.btnDn = new JButton();
        this.btnDn.setText(">");
        jPanel.add(this.btnDn);
        this.btnPC = new JButton();
        this.btnPC.setText("PC");
        jPanel.add(this.btnPC);
        this.mainPanel.add((Component)this.tabDis, "Center");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

