/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import sic.ast.instructions.Instruction;
import sic.common.Conversion;
import sic.common.SICXE;
import sic.disasm.Disassembler;
import sic.sim.Colors;
import sic.sim.Executor;
import sic.sim.vm.Machine;
import sic.sim.vm.Registers;

public class CPUView {
    private final Color colorNochange = Colors.fg;
    private final Color colorChange = Color.BLUE;
    private final Executor executor;
    private final Machine machine;
    private final Registers registers;
    private final Disassembler disassembler;
    private JTextField regA;
    private JTextField regX;
    private JTextField regL;
    private JTextField regS;
    private JTextField regT;
    private JTextField regB;
    private JTextField regSW;
    private JTextField regF;
    private JTextField regFF;
    private JTextField regPC;
    private JTextField txtInstruction;
    private JButton btnStep;
    private JButton btnStartStop;
    public JPanel mainPanel;
    private JLabel lblInfo;

    public CPUView(final Executor executor, Disassembler disassembler) {
        this.$$$setupUI$$$();
        this.executor = executor;
        this.machine = executor.getMachine();
        this.registers = this.machine.registers;
        this.disassembler = disassembler;
        this.btnStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (executor.isRunning()) {
                    executor.stop();
                    CPUView.this.updateView();
                } else {
                    executor.start();
                }
            }
        });
        this.btnStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                executor.step();
                CPUView.this.updateView();
            }
        });
        this.regA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setA(Conversion.hexToInt(CPUView.this.regA.getText()));
                CPUView.this.updateView();
            }
        });
        this.regX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setX(Conversion.hexToInt(CPUView.this.regX.getText()));
                CPUView.this.updateView();
            }
        });
        this.regL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setL(Conversion.hexToInt(CPUView.this.regL.getText()));
                CPUView.this.updateView();
            }
        });
        this.regS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setS(Conversion.hexToInt(CPUView.this.regS.getText()));
                CPUView.this.updateView();
            }
        });
        this.regT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setT(Conversion.hexToInt(CPUView.this.regT.getText()));
                CPUView.this.updateView();
            }
        });
        this.regB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setB(Conversion.hexToInt(CPUView.this.regB.getText()));
                CPUView.this.updateView();
            }
        });
        this.regSW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setSW(Conversion.hexToInt(CPUView.this.regSW.getText()));
                CPUView.this.updateView();
            }
        });
        this.regPC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUView.this.registers.setPC(Conversion.hexToInt(CPUView.this.regPC.getText()));
                CPUView.this.updateView();
            }
        });
        this.updateView();
    }

    private void updateRegWord(JTextField jTextField, int n) {
        String string = Conversion.wordToHex(n);
        if (jTextField.getText().equals(string)) {
            jTextField.setForeground(this.colorNochange);
        } else {
            jTextField.setForeground(this.colorChange);
            jTextField.setText(string);
            jTextField.setToolTipText(String.format("<html>Sgn: %s<br>Dec: %s<br>Oct: %s<br>Bin: %s<html>", SICXE.swordToInt(n), n, Integer.toOctalString(n), Integer.toBinaryString(n)));
        }
    }

    private void updateRegFloat(double d) {
        String string = Conversion.floatToHex(d);
        if (this.regF.getText().equals(string)) {
            this.regF.setForeground(this.colorNochange);
            this.regFF.setForeground(this.colorNochange);
        } else {
            this.regF.setForeground(this.colorChange);
            this.regFF.setForeground(this.colorChange);
            this.regF.setText(string);
            this.regFF.setText(Double.toString(d));
        }
    }

    public void updateView() {
        if (this.machine == null) {
            return;
        }
        this.updateRegWord(this.regA, this.registers.getA());
        this.updateRegWord(this.regX, this.registers.getX());
        this.updateRegWord(this.regL, this.registers.getL());
        this.updateRegWord(this.regS, this.registers.getS());
        this.updateRegWord(this.regT, this.registers.getT());
        this.updateRegWord(this.regB, this.registers.getB());
        this.updateRegWord(this.regSW, this.registers.getSW());
        this.updateRegFloat(this.registers.getF());
        this.updateRegWord(this.regPC, this.registers.getPC());
        this.btnStartStop.setText(this.executor.isRunning() ? "Stop" : "Start");
        Instruction instruction = this.disassembler.disassemble(this.registers.getPC());
        this.txtInstruction.setText(instruction == null ? "" : instruction.toString());
        this.lblInfo.setText((String)(instruction == null ? "" : "<html>" + instruction.explain() + "</html>"));
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setEnabled(true);
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "CPU", 0, 0, null, null));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setAlignmentX(0.5f);
        jPanel.setAutoscrolls(false);
        jPanel.setEnabled(true);
        this.mainPanel.add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel();
        jLabel.setText("X");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.regX = new JTextField();
        this.regX.setColumns(8);
        this.regX.setText("000002");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regX, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("L");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.regL = new JTextField();
        this.regL.setColumns(8);
        this.regL.setText("000003");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regL, gridBagConstraints);
        this.regS = new JTextField();
        this.regS.setText("000004");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regS, gridBagConstraints);
        this.regA = new JTextField();
        this.regA.setColumns(8);
        this.regA.setText("000001");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regA, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("S");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("T");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.regT = new JTextField();
        this.regT.setText("000005");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regT, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("B");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        this.regB = new JTextField();
        this.regB.setText("000006");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regB, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("SW");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        this.regSW = new JTextField();
        this.regSW.setText("000007");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regSW, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("F");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        this.regF = new JTextField();
        this.regF.setColumns(8);
        this.regF.setText("000000000008");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regF, gridBagConstraints);
        this.regFF = new JTextField();
        this.regFF.setText("0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regFF, gridBagConstraints);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("PC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        this.regPC = new JTextField();
        this.regPC.setText("000009");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.regPC, gridBagConstraints);
        this.txtInstruction = new JTextField();
        this.txtInstruction.setText("LDA 0");
        this.txtInstruction.putClientProperty("html.disable", Boolean.FALSE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtInstruction, gridBagConstraints);
        this.btnStartStop = new JButton();
        this.btnStartStop.setText("Start");
        this.btnStartStop.setMnemonic('S');
        this.btnStartStop.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.btnStartStop, gridBagConstraints);
        this.btnStep = new JButton();
        this.btnStep.setText("Step");
        this.btnStep.setMnemonic('T');
        this.btnStep.setDisplayedMnemonicIndex(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.btnStep, gridBagConstraints);
        this.lblInfo = new JLabel();
        Font font = this.$$$getFont$$$("Courier", -1, 12, this.lblInfo.getFont());
        if (font != null) {
            this.lblInfo.setFont(font);
        }
        this.lblInfo.setPreferredSize(new Dimension(280, 120));
        this.lblInfo.setText("");
        this.lblInfo.setVerticalAlignment(1);
        this.lblInfo.setVerticalTextPosition(0);
        this.lblInfo.putClientProperty("html.disable", Boolean.FALSE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this.lblInfo, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel.setLabelFor(this.regX);
        jLabel2.setLabelFor(this.regL);
        jLabel3.setLabelFor(this.regS);
        jLabel4.setLabelFor(this.regA);
        jLabel5.setLabelFor(this.regT);
        jLabel6.setLabelFor(this.regB);
        jLabel7.setLabelFor(this.regSW);
        jLabel8.setLabelFor(this.regF);
        jLabel9.setLabelFor(this.regPC);
    }

    private Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        font2 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font3 = bl ? new Font(font2.getFamily(), font2.getStyle(), font2.getSize()) : new StyleContext().getFont(font2.getFamily(), font2.getStyle(), font2.getSize());
        return font3 instanceof FontUIResource ? font3 : new FontUIResource(font3);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

