/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.addons;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import sic.common.Conversion;
import sic.common.GUI;
import sic.common.SICXE;
import sic.sim.Executor;
import sic.sim.vm.Memory;

public class GraphicalScreen {
    public final int ADDRESS = 40960;
    public final int COLS = 64;
    public final int ROWS = 64;
    public final int PIXELSIZE = 4;
    private final Memory memory;
    private int address;
    private int rows;
    private int cols;
    private int pixelSize;
    private final JFrame view;
    private JPanel pnlScreen;

    void paintScreen(Graphics graphics) {
        if (this.memory == null) {
            return;
        }
        this.memory.setByteRaw(this.address + this.rows * this.cols, 0);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                int n = this.memory.getByteRaw(this.address + i * this.cols + j);
                int n2 = ((n >> 6 & 3) + 1) * 20;
                int n3 = (n >> 4 & 3) * n2;
                int n4 = (n >> 2 & 3) * n2;
                int n5 = (n & 3) * n2;
                graphics.setColor(new Color(n3, n4, n5));
                graphics.fillRect(j * this.pixelSize, i * this.pixelSize, this.pixelSize, this.pixelSize);
            }
        }
        this.memory.setByteRaw(this.address + this.rows * this.cols, 1);
    }

    public void clearScreen() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.memory.setByteRaw(this.address + i * this.cols + j, 0);
            }
        }
    }

    private JFrame createView() {
        final JFrame jFrame = new JFrame("Graphical screen");
        jFrame.setResizable(false);
        this.pnlScreen = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                GraphicalScreen.this.paintScreen(graphics);
            }
        };
        this.pnlScreen.setToolTipText("Double click to clear screen.");
        this.pnlScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    GraphicalScreen.this.clearScreen();
                    GraphicalScreen.this.updateView();
                }
                if (mouseEvent.getButton() == 3) {
                    JPanel jPanel = GraphicalScreen.this.createSettingsPane();
                    GUI.showInJFrame(jFrame, "Settings", jPanel);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new BevelBorder(1));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.pnlScreen);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(jPanel);
        jFrame.setContentPane(jPanel2);
        return jFrame;
    }

    public void setSize(int n, int n2) {
        this.setScreen(this.address, n, n2, this.pixelSize);
    }

    public void setScreen(int n, int n2, int n3, int n4) {
        int n5 = 1048575 - n2 * n3;
        if (n > n5) {
            n = n5;
        }
        this.address = n;
        this.rows = n3;
        this.cols = n2;
        this.pixelSize = n4;
        this.pnlScreen.setPreferredSize(new Dimension(n2 * n4, n3 * n4));
        this.updateView();
        this.view.pack();
    }

    public void toggleView() {
        this.view.setVisible(!this.view.isVisible());
    }

    public void updateView() {
        this.pnlScreen.repaint();
    }

    public GraphicalScreen(Executor executor) {
        this.memory = executor.getMachine().memory;
        this.view = this.createView();
        this.setScreen(40960, 64, 64, 4);
    }

    public JPanel createSettingsPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2, 0, 0));
        final JTextField jTextField = GUI.createField(jPanel, "Address", Conversion.addrToHex(this.address), 10);
        final JTextField jTextField2 = GUI.createField(jPanel, "Columns", Integer.toString(this.cols), 10);
        final JTextField jTextField3 = GUI.createField(jPanel, "Rows", Integer.toString(this.rows), 10);
        final JTextField jTextField4 = GUI.createField(jPanel, "Pixel size", Integer.toString(this.pixelSize), 10);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                int n4;
                try {
                    n4 = SICXE.intToAddr(Conversion.hexToInt(jTextField.getText()));
                    n3 = Integer.parseInt(jTextField2.getText());
                    n2 = Integer.parseInt(jTextField3.getText());
                    n = Integer.parseInt(jTextField4.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                GraphicalScreen.this.setScreen(n4, n3, n2, n);
            }
        };
        jTextField.addActionListener(actionListener);
        jTextField2.addActionListener(actionListener);
        jTextField3.addActionListener(actionListener);
        jTextField4.addActionListener(actionListener);
        return jPanel;
    }
}

