/*
 * Decompiled with CFR 0.152.
 */
package sic.link.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sic.link.Linker;
import sic.link.LinkerError;
import sic.link.Options;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.Section;
import sic.link.section.Sections;
import sic.link.utils.Writer;

public class LinkerCli {
    public static File link(Options options, List<String> list) throws LinkerError {
        Linker linker = new Linker(list, options);
        if (options.isEditing()) {
            Sections sections = linker.parse();
            sections = LinkerCli.sectionEdit(sections);
            Section section = linker.passAndCombine(sections);
            Writer writer = new Writer(section, options);
            return writer.write();
        }
        Section section = linker.link();
        Writer writer = new Writer(section, options);
        return writer.write();
    }

    /*
     * Could not resolve type clashes
     */
    public static Sections sectionEdit(Sections sections) {
        System.out.println("SIC Linker Interactive Section Editor");
        System.out.println("Enter 'help' for list of commands or 'done' to finish editing");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "> ";
        boolean bl = false;
        block37: while (!bl) {
            System.out.print(string);
            try {
                Object object2;
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    bl = true;
                    break;
                }
                String[] stringArray = string2.split(" ");
                if (stringArray.length == 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object2 : stringArray) {
                    if (((String)object2).length() <= 0) continue;
                    arrayList.add((String)object2);
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                if (stringArray.length == 0) continue;
                switch (stringArray[0]) {
                    case "list": {
                        Iterator<ExtRef> iterator;
                        System.out.println("     Name       Defs      Refs");
                        int n = 0;
                        object2 = sections.getSections().iterator();
                        while (object2.hasNext()) {
                            iterator = (Section)object2.next();
                            System.out.println(String.format("%2d)  %-6s |  %6d |  %6d |", n, ((Section)((Object)iterator)).getName(), ((Section)((Object)iterator)).getExtDefs().size(), ((Section)((Object)iterator)).getExtRefs().size()));
                            ++n;
                        }
                        continue block37;
                    }
                    case "info": {
                        object2 = null;
                        if (stringArray.length > 1) {
                            object2 = sections.getSection(stringArray[1]);
                        }
                        if (object2 == null) {
                            System.out.println("Please specify a valid section name");
                            break;
                        }
                        System.out.println("External definitions:");
                        for (Object object3 : ((Section)object2).getExtDefs()) {
                            System.out.println(String.format(" - %-6s at 0x%06X", ((ExtDef)object3).getName(), ((ExtDef)object3).getAddress()));
                        }
                        if (((Section)object2).getExtDefs().size() == 0) {
                            System.out.println(" no definitions ");
                        }
                        System.out.println("External references:");
                        for (Object object3 : ((Section)object2).getExtRefs()) {
                            System.out.println(String.format(" - %-6s", ((ExtRef)object3).getName()));
                        }
                        if (((Section)object2).getExtRefs().size() != 0) continue block37;
                        System.out.println(" no references ");
                        break;
                    }
                    case "rename": {
                        Iterator<ExtRef> iterator = null;
                        String string3 = null;
                        if (stringArray.length > 1 && ((String)((Object)(iterator = stringArray[1]))).length() == 0) {
                            iterator = null;
                        }
                        if (stringArray.length > 2 && (string3 = stringArray[2]).length() == 0) {
                            string3 = null;
                        }
                        if (iterator == null) {
                            System.out.println("Please specify a valid section name");
                            break;
                        }
                        if (string3 == null) {
                            System.out.println("Please specify a new name for section " + (String)((Object)iterator));
                            break;
                        }
                        if (string3.length() > 6) {
                            System.out.println("New section name should have 6 characters or less.");
                            break;
                        }
                        try {
                            sections.rename((String)((Object)iterator), string3);
                        }
                        catch (LinkerError linkerError) {
                            System.out.println(linkerError.getMessage());
                        }
                        break;
                    }
                    case "rename-ref": 
                    case "rename-def": {
                        Iterator<ExtRef> iterator = null;
                        String string4 = null;
                        String string5 = null;
                        boolean bl2 = stringArray[0].equals("rename-def");
                        if (stringArray.length > 1 && ((String)((Object)(iterator = stringArray[1]))).length() == 0) {
                            iterator = null;
                        }
                        if (stringArray.length > 2 && (string4 = stringArray[2]).length() == 0) {
                            string4 = null;
                        }
                        if (stringArray.length > 3 && (string5 = stringArray[3]).length() == 0) {
                            string5 = null;
                        }
                        if (iterator == null) {
                            System.out.println("Please specify a valid section name");
                            break;
                        }
                        if (string4 == null) {
                            System.out.println("Please specify a valid symbol name");
                            break;
                        }
                        if (string5 == null) {
                            System.out.println("Please specify a new name for symbol " + string4);
                            break;
                        }
                        if (string5.length() > 6) {
                            System.out.println("New symbol name should have 6 characters or less.");
                            break;
                        }
                        try {
                            if (bl2) {
                                sections.renameDef((String)((Object)iterator), string4, string5);
                                break;
                            }
                            sections.renameRef((String)((Object)iterator), string4, string5);
                        }
                        catch (LinkerError linkerError) {
                            System.out.println(linkerError.getMessage());
                        }
                        break;
                    }
                    case "remove": {
                        Iterator<ExtRef> iterator = null;
                        if (stringArray.length > 1 && ((String)((Object)(iterator = stringArray[1]))).length() == 0) {
                            iterator = null;
                        }
                        if (iterator == null) {
                            System.out.println("Please specify a valid section name");
                            break;
                        }
                        try {
                            sections.remove((String)((Object)iterator));
                        }
                        catch (LinkerError linkerError) {
                            System.out.println(linkerError.getMessage());
                        }
                        break;
                    }
                    case "remove-def": 
                    case "remove-ref": {
                        Iterator<ExtRef> iterator = null;
                        String string6 = null;
                        boolean bl3 = stringArray[0].equals("remove-def");
                        if (stringArray.length > 1 && ((String)((Object)(iterator = stringArray[1]))).length() == 0) {
                            iterator = null;
                        }
                        if (stringArray.length > 2 && (string6 = stringArray[2]).length() == 0) {
                            string6 = null;
                        }
                        if (iterator == null) {
                            System.out.println("Please specify a valid section name");
                            break;
                        }
                        if (string6 == null) {
                            System.out.println("Please specify a valid symbol name");
                            break;
                        }
                        try {
                            if (bl3) {
                                sections.removeDef((String)((Object)iterator), string6);
                                break;
                            }
                            sections.removeRef((String)((Object)iterator), string6);
                        }
                        catch (LinkerError linkerError) {
                            System.out.println(linkerError.getMessage());
                        }
                        break;
                    }
                    case "move": {
                        Iterator<ExtRef> iterator = null;
                        int n = -1;
                        if (stringArray.length > 1 && ((String)((Object)(iterator = stringArray[1]))).length() == 0) {
                            iterator = null;
                        }
                        if (stringArray.length > 2) {
                            try {
                                n = Integer.parseInt(stringArray[2]);
                            }
                            catch (Throwable throwable) {
                                n = -1;
                            }
                        }
                        if (iterator == null) {
                            System.out.println("Please specify a valid section name");
                            break;
                        }
                        if (n < 0) {
                            System.out.println("Please specify a valid position");
                            break;
                        }
                        try {
                            sections.move((String)((Object)iterator), n);
                        }
                        catch (LinkerError linkerError) {
                            System.out.println(linkerError.getMessage());
                        }
                        break;
                    }
                    case "done": {
                        bl = true;
                        break;
                    }
                    default: {
                        System.out.println("Available commands:");
                        System.out.println();
                        System.out.println("  list : prints a list of sections");
                        System.out.println("  info <section> : prints detailed info about a section");
                        System.out.println("  rename <section> <new name>: renames a section");
                        System.out.println("  remove <section> : removes a section");
                        System.out.println("  rename-def <section> <symbol> <new name>: renames a definition in the section");
                        System.out.println("  rename-ref <section> <symbol> <new name>: renames a reference in the section");
                        System.out.println("  remove-def <section> <symbol> : removes a definition in the section");
                        System.out.println("  remove-ref <section> <symbol> : removes a reference in the section");
                        System.out.println("  move <section> <position>: moves section to specified position");
                        System.out.println();
                        System.out.println("  done : closes the editor");
                        System.out.println("  help : prints this help");
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println("IO Exception, please try again");
            }
        }
        System.out.println("exiting interactive reorder");
        return sections;
    }
}

