/*
 * Decompiled with CFR 0.152.
 */
package sic.link;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import sic.link.LinkerError;
import sic.link.Options;
import sic.link.section.ExtDef;
import sic.link.section.Section;
import sic.link.section.Sections;
import sic.link.utils.Parser;
import sic.link.visitors.FirstPassVisitor;
import sic.link.visitors.SecondPassVisitor;

public class Linker {
    private static final String PHASE = "linker";
    private List<String> inputs;
    private Options options;

    public Linker(List<String> list, Options options) {
        this.inputs = list;
        this.options = options;
    }

    public Section link() throws LinkerError {
        Sections sections = this.parse();
        Section section = this.passAndCombine(sections);
        return section;
    }

    public Sections parse() throws LinkerError {
        Sections sections = new Sections();
        for (String string : this.inputs) {
            Parser parser = new Parser(string, this.options);
            sections.addSections(parser.parse());
        }
        if (sections.getSections().size() == 0) {
            throw new LinkerError(PHASE, "No sections found in given input files.");
        }
        this.log("read " + sections.getSections().size() + " sections", sections.getSections());
        if (this.options.getMain() != null) {
            this.log("moving " + this.options.getMain() + " (main) to start of sections list");
            try {
                sections.move(this.options.getMain(), 0);
            }
            catch (LinkerError linkerError) {
                throw new LinkerError("options", "specified main section " + this.options.getMain() + " does not exist");
            }
        }
        if (this.options.getOutputName() != null) {
            Object object = this.options.getOutputName().replace(".obj", "");
            if (((String)object).length() > 6) {
                object = ((String)object).substring(0, 6);
            }
            sections.setName((String)object);
            this.log("setting output section name to " + sections.getName());
        }
        return sections;
    }

    public Section passAndCombine(Sections sections) throws LinkerError {
        if (sections.getSections().size() == 0) {
            throw new LinkerError(PHASE, "No sections to link.");
        }
        if (sections.getName() == null) {
            sections.setName(sections.getSections().get(0).getName());
        }
        HashMap<String, ExtDef> hashMap = new HashMap<String, ExtDef>();
        this.log("starting first pass");
        FirstPassVisitor firstPassVisitor = new FirstPassVisitor(hashMap);
        firstPassVisitor.visit(sections);
        this.log(sections.getSections(), hashMap.values());
        this.log("starting second pass");
        SecondPassVisitor secondPassVisitor = new SecondPassVisitor(sections.getName(), hashMap, this.options);
        secondPassVisitor.visit(sections);
        this.log("cleaning the output section (R and M records)");
        sections.clean();
        this.log("combining section into one");
        Section section = sections.combine(this.options.isKeep());
        if (this.options.isVerbose()) {
            System.out.println();
            System.out.println("finished linking");
            System.out.println("output linked section: ");
            System.out.println(section);
        }
        return section;
    }

    private void log(String string) {
        if (this.options.isVerbose()) {
            System.out.println();
            System.out.println(string);
        }
    }

    private void log(String string, List<Section> list) {
        if (this.options.isVerbose()) {
            System.out.println();
            System.out.println(string);
            for (Section section : list) {
                System.out.println(section.toString());
            }
        }
    }

    private void log(List<Section> list, Collection<ExtDef> collection) {
        if (this.options.isVerbose()) {
            System.out.println();
            System.out.println("Control sections:");
            System.out.println(" Name     CS addr    Length ");
            for (Section object : list) {
                System.out.println(String.format("%6s | 0x%06X | 0x%06X", object.getName(), object.getStart(), object.getLength()));
            }
            System.out.println("");
            System.out.println("External symbols:");
            System.out.println(" Name     CS addr    ES addr");
            for (ExtDef extDef : collection) {
                System.out.println(String.format("%6s | 0x%06X | 0x%06X", extDef.getName(), extDef.getCsAddress(), extDef.getAddress()));
            }
        }
    }
}

