/*
 * Decompiled with CFR 0.152.
 */
package sic.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import sic.common.Logger;

public class Utils {
    public static boolean isInInterval(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String getFileBasename(String string) {
        int n = string.lastIndexOf(".");
        return n != -1 ? string.substring(0, n) : string;
    }

    public static String readString(Reader reader, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (n-- > 0) {
            stringBuilder.append((char)reader.read());
        }
        return stringBuilder.toString();
    }

    public static int readByte(Reader reader) throws IOException {
        return Integer.parseInt(Utils.readString(reader, 2), 16);
    }

    public static int readWord(Reader reader) throws IOException {
        return Integer.parseInt(Utils.readString(reader, 6), 16);
    }

    public static String readFile(File file) {
        byte[] byArray = new byte[(int)file.length()];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ((InputStream)fileInputStream).read(byArray);
        }
        catch (IOException iOException) {
            Logger.fmterr("Error reading file '%s'.", file.getName());
            System.exit(1);
        }
        return new String(byArray);
    }

    public static String readFile(String string) {
        return Utils.readFile(new File(string));
    }

    public static String readStdin() {
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static Writer createFileWriter(String string) {
        try {
            return new FileWriter(string);
        }
        catch (IOException iOException) {
            Logger.fmterr("Error creating file '%s'", string);
            System.exit(1);
            return null;
        }
    }
}

