/*
 * Decompiled with CFR 0.152.
 */
package sic.common;

public class Flags {
    public static final int NONE = 0;
    public static final int MASK_NI = 3;
    public static final int SIC = 0;
    public static final int IMMEDIATE = 1;
    public static final int INDIRECT = 2;
    public static final int SIMPLE = 3;
    public static final int MASK_XBPE = 240;
    public static final int MASK_XBP = 224;
    public static final int MASK_BP = 96;
    public static final int INDEXED = 128;
    public static final int BASERELATIVE = 64;
    public static final int PCRELATIVE = 32;
    public static final int EXTENDED = 16;
    private int ni;
    private int xbpe;

    public Flags(int n, int n2) {
        this.set_ni(n);
        this.set_xbpe(n2);
    }

    public Flags() {
        this(0, 0);
    }

    public String toString() {
        String string = "--";
        if (this.is_ni(3)) {
            string = "ni";
        } else if (this.is_ni(2)) {
            string = "n-";
        } else if (this.is_ni(1)) {
            string = "-i";
        }
        return string + (this.isIndexed() ? "x" : "-") + (this.isBaseRelative() ? "b" : "-") + (this.isPCRelative() ? "p" : "-") + (this.isExtended() ? "e" : "-");
    }

    public String operandToString(String string) {
        if (this.isImmediate()) {
            return "#" + string;
        }
        if (this.isIndirect()) {
            return "@" + string;
        }
        if (this.isIndexed()) {
            return string + ",X";
        }
        return string;
    }

    public int get_ni() {
        return this.ni & 3;
    }

    public void set_ni(int n) {
        this.ni = n & 3;
    }

    public boolean is_ni(int n) {
        return (this.ni & 3) == n;
    }

    public boolean isSic() {
        return this.is_ni(0);
    }

    public boolean isImmediate() {
        return this.is_ni(1);
    }

    public boolean isIndirect() {
        return this.is_ni(2);
    }

    public boolean isSimple() {
        int n = this.ni & 3;
        return n == 3 || n == 0;
    }

    public byte combineWithOpcode(int n) {
        return (byte)(n & 0xFC | this.ni & 3);
    }

    public int get_xbpe() {
        return this.xbpe & 0xF0;
    }

    public void set_xbpe(int n) {
        this.xbpe = n & 0xF0;
    }

    public int get_x() {
        return (byte)(this.xbpe & 0x80);
    }

    public boolean isIndexed() {
        return (this.xbpe & 0x80) == 128;
    }

    public void setIndexed() {
        this.xbpe |= 0x80;
    }

    public boolean isBaseRelative() {
        return (this.xbpe & 0x40) == 64;
    }

    public void setBaseRelative() {
        this.xbpe |= 0x40;
    }

    public boolean isPCRelative() {
        return (this.xbpe & 0x20) == 32;
    }

    public void setPCRelative() {
        this.xbpe |= 0x20;
    }

    public boolean isRelative() {
        return this.isPCRelative() || this.isBaseRelative();
    }

    public boolean isAbsolute() {
        return (this.xbpe & 0x60) == 0;
    }

    public boolean isExtended() {
        return (this.xbpe & 0x10) == 16;
    }

    public void setExtended() {
        this.xbpe |= 0x10;
    }

    public int operandSic(int n, int n2) {
        return (n & 0x7F) << 8 | n2 & 0xFF;
    }

    public int operandF3(int n, int n2) {
        return (n & 0xF) << 8 | n2;
    }

    public int operandF4(int n, int n2, int n3) {
        return (n & 0xF) << 16 | n2 << 8 | n3;
    }

    public int operandPCRelative(int n) {
        return n >= 2048 ? n - 4096 : n;
    }

    public int minOperand() {
        if (this.isExtended()) {
            return 0;
        }
        return this.isImmediate() ? -2048 : 0;
    }

    public int maxOperand() {
        if (this.isExtended()) {
            return 1048575;
        }
        return 4095;
    }
}

